/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.filter;

import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.filter.LogFormatter;
import com.twitter.finagle.http.filter.LogFormatter$class;
import com.twitter.util.Duration;
import com.twitter.util.Time$;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u001b\t\u00112i\\7n_:dun\u001a$pe6\fG\u000f^3s\u0015\t\u0019A!\u0001\u0004gS2$XM\u001d\u0006\u0003\u000b\u0019\tA\u0001\u001b;ua*\u0011q\u0001C\u0001\bM&t\u0017m\u001a7f\u0015\tI!\"A\u0004uo&$H/\u001a:\u000b\u0003-\t1aY8n\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\r\u0019><gi\u001c:nCR$XM\u001d\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"!\u0006\u0001\t\u000fu\u0001!\u0019!C\u0001=\u0005QA)\u0019;f\r>\u0014X.\u0019;\u0016\u0003}\u0001\"\u0001I\u0016\u000e\u0003\u0005R!AI\u0012\u0002\tQLW.\u001a\u0006\u0003I\u0015\nA\u0001\\1oO*\u0011aeJ\u0001\bG>lWn\u001c8t\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\n\u00051\n#A\u0004$bgR$\u0015\r^3G_Jl\u0017\r\u001e\u0005\u0007]\u0001\u0001\u000b\u0011B\u0010\u0002\u0017\u0011\u000bG/\u001a$pe6\fG\u000f\t\u0005\u0006a\u0001!\t!M\u0001\u0007M>\u0014X.\u0019;\u0015\tIJt\b\u0012\t\u0003g]j\u0011\u0001\u000e\u0006\u0003IUR\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029i\t11\u000b\u001e:j]\u001eDQAO\u0018A\u0002m\nqA]3rk\u0016\u001cH\u000f\u0005\u0002={5\tA!\u0003\u0002?\t\t9!+Z9vKN$\b\"\u0002!0\u0001\u0004\t\u0015\u0001\u0003:fgB|gn]3\u0011\u0005q\u0012\u0015BA\"\u0005\u0005!\u0011Vm\u001d9p]N,\u0007\"B#0\u0001\u00041\u0015\u0001\u0004:fgB|gn]3US6,\u0007CA$K\u001b\u0005A%BA%\t\u0003\u0011)H/\u001b7\n\u0005-C%\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u000b5\u0003A\u0011\u0001(\u0002\u001f\u0019|'/\\1u\u000bb\u001cW\r\u001d;j_:$BaT+WIB\u0011\u0001k\u0015\b\u0003\u001fEK!A\u0015\t\u0002\rA\u0013X\rZ3g\u0013\tADK\u0003\u0002S!!)!\b\u0014a\u0001w!)q\u000b\u0014a\u00011\u0006IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u00033\u0006t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005uc\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\t\u0001\u0007#A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'!\u0003+ie><\u0018M\u00197f\u0015\t\u0001\u0007\u0003C\u0003F\u0019\u0002\u0007a\tC\u0003g\u0001\u0011\u0005q-A\u0007g_Jl\u0017\r\u001e;fI\u0012\u000bG/\u001a\u000b\u0002\u001f\u0002")
public class CommonLogFormatter
implements LogFormatter {
    private final FastDateFormat DateFormat;

    @Override
    public String escape(String s) {
        return LogFormatter$class.escape(this, s);
    }

    public FastDateFormat DateFormat() {
        return this.DateFormat;
    }

    public String format(Request request, Response response, Duration responseTime) {
        String remoteAddr = request.remoteAddress().getHostAddress();
        int contentLength2 = response.length();
        String contentLengthStr = contentLength2 > 0 ? ((Object)BoxesRunTime.boxToInteger((int)contentLength2)).toString() : "-";
        String uaStr = (String)request.userAgent().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "-";
            }
        });
        StringBuilder builder = new StringBuilder();
        builder.append(remoteAddr);
        builder.append(" - - [");
        builder.append(this.formattedDate());
        builder.append("] \"");
        builder.append(this.escape(request.method().toString()));
        builder.append(' ');
        builder.append(this.escape(request.uri()));
        builder.append(' ');
        builder.append(this.escape(request.version().toString()));
        builder.append("\" ");
        builder.append(((Object)BoxesRunTime.boxToInteger((int)response.statusCode())).toString());
        builder.append(' ');
        builder.append(contentLengthStr);
        builder.append(' ');
        builder.append(responseTime.inMillis());
        builder.append(" \"");
        builder.append(this.escape(uaStr));
        builder.append('\"');
        return builder.toString();
    }

    public String formatException(Request request, Throwable throwable, Duration responseTime) {
        throw new UnsupportedOperationException("Log throwables as empty 500s instead");
    }

    public String formattedDate() {
        return this.DateFormat().format(Time$.MODULE$.now().toDate());
    }

    public CommonLogFormatter() {
        LogFormatter$class.$init$(this);
        this.DateFormat = FastDateFormat.getInstance((String)"dd/MMM/yyyy:HH:mm:ss Z", (TimeZone)TimeZone.getTimeZone("GMT"));
    }
}

