/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.balancer;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.RateLimiter;
import com.twitter.util.Await;
import com.twitter.util.Awaitable;
import com.twitter.util.Function;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.client.monitor.MonitorServiceClient;
import org.apache.distributedlog.service.ClientUtils;
import org.apache.distributedlog.service.DLSocketAddress;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.service.DistributedLogClientBuilder;
import org.apache.distributedlog.service.balancer.Balancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;

public class ClusterBalancer
implements Balancer {
    private static final Logger logger = LoggerFactory.getLogger(ClusterBalancer.class);
    protected final DistributedLogClientBuilder clientBuilder;
    protected final DistributedLogClient client;
    protected final MonitorServiceClient monitor;

    public ClusterBalancer(DistributedLogClientBuilder clientBuilder) {
        this(clientBuilder, ClientUtils.buildClient(clientBuilder));
    }

    ClusterBalancer(DistributedLogClientBuilder clientBuilder, Pair<DistributedLogClient, MonitorServiceClient> clientPair) {
        this.clientBuilder = clientBuilder;
        this.client = (DistributedLogClient)clientPair.getLeft();
        this.monitor = (MonitorServiceClient)clientPair.getRight();
    }

    static Pair<DistributedLogClient, MonitorServiceClient> createDistributedLogClient(SocketAddress host, DistributedLogClientBuilder clientBuilder) {
        DistributedLogClientBuilder newBuilder = DistributedLogClientBuilder.newBuilder((DistributedLogClientBuilder)clientBuilder).host(host);
        return ClientUtils.buildClient(newBuilder);
    }

    @Override
    public void balanceAll(String source, int rebalanceConcurrency, Optional<RateLimiter> rebalanceRateLimiter) {
        this.balance(0, 0.0, rebalanceConcurrency, (Optional<String>)Optional.of((Object)source), rebalanceRateLimiter);
    }

    @Override
    public void balance(int rebalanceWaterMark, double rebalanceTolerancePercentage, int rebalanceConcurrency, Optional<RateLimiter> rebalanceRateLimiter) {
        Optional source = Optional.absent();
        this.balance(rebalanceWaterMark, rebalanceTolerancePercentage, rebalanceConcurrency, (Optional<String>)source, rebalanceRateLimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void balance(int rebalanceWaterMark, double rebalanceTolerancePercentage, int rebalanceConcurrency, Optional<String> source, Optional<RateLimiter> rebalanceRateLimiter) {
        Map distribution = this.monitor.getStreamOwnershipDistribution();
        if (distribution.size() <= 1) {
            return;
        }
        InetSocketAddress sourceAddr = null;
        if (source.isPresent()) {
            sourceAddr = DLSocketAddress.parseSocketAddress((String)((String)source.get()));
            logger.info("Balancer source is {}", (Object)sourceAddr);
            if (!distribution.containsKey(sourceAddr)) {
                return;
            }
        }
        ArrayList<Host> hosts = new ArrayList<Host>(distribution.size());
        for (Map.Entry entry : distribution.entrySet()) {
            Host host = new Host((SocketAddress)entry.getKey(), (Set)entry.getValue(), this.clientBuilder);
            hosts.add(host);
        }
        Collections.sort(hosts, new HostComparator());
        try {
            int moveFromLowWaterMark;
            void var11_16;
            int hostIdxMoveFrom = -1;
            if (null != sourceAddr) {
                for (Host host : hosts) {
                    ++hostIdxMoveFrom;
                    if (!((Object)sourceAddr).equals(host.address)) continue;
                    break;
                }
            }
            boolean bl = false;
            for (Host host : hosts) {
                var11_16 += host.streams.size();
            }
            double d = hostIdxMoveFrom >= 0 ? (double)var11_16 / (double)(hosts.size() - 1) : (double)var11_16 / (double)hosts.size();
            int moveToHighWaterMark = Math.max(1, (int)(d + d * rebalanceTolerancePercentage / 100.0));
            if (hostIdxMoveFrom >= 0) {
                moveFromLowWaterMark = Math.max(0, rebalanceWaterMark);
                this.moveStreams(hosts, new AtomicInteger(hostIdxMoveFrom), moveFromLowWaterMark, new AtomicInteger(hosts.size() - 1), moveToHighWaterMark, rebalanceRateLimiter);
                this.moveRemainingStreamsFromSource((Host)hosts.get(hostIdxMoveFrom), hosts, rebalanceRateLimiter);
            } else {
                moveFromLowWaterMark = Math.max((int)Math.ceil(d), rebalanceWaterMark);
                AtomicInteger moveFrom = new AtomicInteger(0);
                AtomicInteger moveTo = new AtomicInteger(hosts.size() - 1);
                while (moveFrom.get() < moveTo.get()) {
                    this.moveStreams(hosts, moveFrom, moveFromLowWaterMark, moveTo, moveToHighWaterMark, rebalanceRateLimiter);
                    moveFrom.incrementAndGet();
                }
            }
        }
        finally {
            for (Host host : hosts) {
                host.close();
            }
        }
    }

    void moveStreams(List<Host> hosts, AtomicInteger hostIdxMoveFrom, int moveFromLowWaterMark, AtomicInteger hostIdxMoveTo, int moveToHighWaterMark, Optional<RateLimiter> rateLimiter) {
        if (hostIdxMoveFrom.get() < 0 || hostIdxMoveFrom.get() >= hosts.size() || hostIdxMoveTo.get() < 0 || hostIdxMoveTo.get() >= hosts.size() || hostIdxMoveFrom.get() >= hostIdxMoveTo.get()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Moving streams : hosts = {}, from = {}, to = {} : from_low_water_mark = {}, to_high_water_mark = {}", new Object[]{hosts, hostIdxMoveFrom.get(), hostIdxMoveTo.get(), moveFromLowWaterMark, moveToHighWaterMark});
        }
        Host hostMoveFrom = hosts.get(hostIdxMoveFrom.get());
        int numStreamsOnFromHost = hostMoveFrom.streams.size();
        if (numStreamsOnFromHost <= moveFromLowWaterMark) {
            return;
        }
        int numStreamsToMove = numStreamsOnFromHost - moveFromLowWaterMark;
        LinkedList<String> streamsToMove = new LinkedList<String>(hostMoveFrom.streams);
        Collections.shuffle(streamsToMove);
        if (logger.isDebugEnabled()) {
            logger.debug("Try to move {} streams from host {} : streams = {}", new Object[]{numStreamsToMove, hostMoveFrom.address, streamsToMove});
        }
        while (numStreamsToMove-- > 0 && !streamsToMove.isEmpty()) {
            if (rateLimiter.isPresent()) {
                ((RateLimiter)rateLimiter.get()).acquire();
            }
            Host hostMoveTo = hosts.get(hostIdxMoveTo.get());
            while (hostMoveTo.streams.size() >= moveToHighWaterMark) {
                int hostIdx = hostIdxMoveTo.decrementAndGet();
                logger.info("move to host : {}, from {}", (Object)hostIdx, (Object)hostIdxMoveFrom.get());
                if (hostIdx <= hostIdxMoveFrom.get()) {
                    return;
                }
                hostMoveTo = hosts.get(hostIdx);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Target host to move moved to host {} @ {}", (Object)hostIdx, (Object)hostMoveTo);
            }
            String stream = streamsToMove.remove();
            if (!this.moveStream(stream, hostMoveFrom, hostMoveTo)) continue;
            hostMoveFrom.streams.remove(stream);
            hostMoveTo.streams.add(stream);
        }
    }

    void moveRemainingStreamsFromSource(Host source, List<Host> hosts, Optional<RateLimiter> rateLimiter) {
        LinkedList<String> streamsToMove = new LinkedList<String>(source.streams);
        Collections.shuffle(streamsToMove);
        if (logger.isDebugEnabled()) {
            logger.debug("Try to move remaining streams from {} : {}", (Object)source, streamsToMove);
        }
        int hostIdx = hosts.size() - 1;
        while (!streamsToMove.isEmpty()) {
            String stream;
            if (rateLimiter.isPresent()) {
                ((RateLimiter)rateLimiter.get()).acquire();
            }
            Host target = hosts.get(hostIdx);
            if (!target.address.equals(source.address) && this.moveStream(stream = streamsToMove.remove(), source, target)) {
                source.streams.remove(stream);
                target.streams.add(stream);
            }
            if (--hostIdx >= 0) continue;
            hostIdx = hosts.size() - 1;
        }
    }

    private boolean moveStream(String stream, Host from, Host to) {
        try {
            this.doMoveStream(stream, from, to);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void doMoveStream(final String stream, final Host from, final Host to) throws Exception {
        logger.info("Moving stream {} from {} to {}.", new Object[]{stream, from.address, to.address});
        Await.result((Awaitable)from.getClient().release(stream).flatMap((Function1)new Function<Void, Future<Void>>(){

            public Future<Void> apply(Void result) {
                logger.info("Released stream {} from {}.", (Object)stream, (Object)from.address);
                return to.getMonitor().check(stream).addEventListener((FutureEventListener)new FutureEventListener<Void>(){

                    public void onSuccess(Void value) {
                        logger.info("Moved stream {} from {} to {}.", new Object[]{stream, from.address, to.address});
                    }

                    public void onFailure(Throwable cause) {
                        logger.info("Failed to move stream {} from {} to {} : ", new Object[]{stream, from.address, to.address, cause});
                    }
                });
            }
        }));
    }

    @Override
    public void close() {
        this.client.close();
    }

    static class HostComparator
    implements Comparator<Host>,
    Serializable {
        private static final long serialVersionUID = 7984973796525102538L;

        HostComparator() {
        }

        @Override
        public int compare(Host h1, Host h2) {
            return h2.streams.size() - h1.streams.size();
        }
    }

    static class Host {
        final SocketAddress address;
        final Set<String> streams;
        final DistributedLogClientBuilder clientBuilder;
        DistributedLogClient client = null;
        MonitorServiceClient monitor = null;

        Host(SocketAddress address, Set<String> streams, DistributedLogClientBuilder clientBuilder) {
            this.address = address;
            this.streams = streams;
            this.clientBuilder = clientBuilder;
        }

        private void initializeClientsIfNeeded() {
            if (null == this.client) {
                Pair<DistributedLogClient, MonitorServiceClient> clientPair = ClusterBalancer.createDistributedLogClient(this.address, this.clientBuilder);
                this.client = (DistributedLogClient)clientPair.getLeft();
                this.monitor = (MonitorServiceClient)clientPair.getRight();
            }
        }

        synchronized DistributedLogClient getClient() {
            this.initializeClientsIfNeeded();
            return this.client;
        }

        synchronized MonitorServiceClient getMonitor() {
            this.initializeClientsIfNeeded();
            return this.monitor;
        }

        synchronized void close() {
            if (null != this.client) {
                this.client.close();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Host(").append(this.address).append(")");
            return sb.toString();
        }
    }
}

