/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thrift.thrift;

import com.twitter.finagle.thrift.thrift.AnnotationType;
import com.twitter.finagle.thrift.thrift.Endpoint;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class BinaryAnnotation
implements TBase<BinaryAnnotation, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("BinaryAnnotation");
    private static final TField KEY_FIELD_DESC = new TField("key", 11, 1);
    private static final TField VALUE_FIELD_DESC = new TField("value", 11, 2);
    private static final TField ANNOTATION_TYPE_FIELD_DESC = new TField("annotation_type", 8, 3);
    private static final TField HOST_FIELD_DESC = new TField("host", 12, 4);
    public String key;
    public ByteBuffer value;
    public AnnotationType annotation_type;
    public Endpoint host;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public BinaryAnnotation() {
    }

    public BinaryAnnotation(String string, ByteBuffer byteBuffer, AnnotationType annotationType) {
        this();
        this.key = string;
        this.value = byteBuffer;
        this.annotation_type = annotationType;
    }

    public BinaryAnnotation(BinaryAnnotation binaryAnnotation) {
        if (binaryAnnotation.isSetKey()) {
            this.key = binaryAnnotation.key;
        }
        if (binaryAnnotation.isSetValue()) {
            this.value = TBaseHelper.copyBinary((ByteBuffer)binaryAnnotation.value);
        }
        if (binaryAnnotation.isSetAnnotation_type()) {
            this.annotation_type = binaryAnnotation.annotation_type;
        }
        if (binaryAnnotation.isSetHost()) {
            this.host = new Endpoint(binaryAnnotation.host);
        }
    }

    public BinaryAnnotation deepCopy() {
        return new BinaryAnnotation(this);
    }

    public void clear() {
        this.key = null;
        this.value = null;
        this.annotation_type = null;
        this.host = null;
    }

    public String getKey() {
        return this.key;
    }

    public BinaryAnnotation setKey(String string) {
        this.key = string;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean bl) {
        if (!bl) {
            this.key = null;
        }
    }

    public byte[] getValue() {
        this.setValue(TBaseHelper.rightSize((ByteBuffer)this.value));
        return this.value.array();
    }

    public ByteBuffer BufferForValue() {
        return this.value;
    }

    public BinaryAnnotation setValue(byte[] byArray) {
        this.setValue(ByteBuffer.wrap(byArray));
        return this;
    }

    public BinaryAnnotation setValue(ByteBuffer byteBuffer) {
        this.value = byteBuffer;
        return this;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean bl) {
        if (!bl) {
            this.value = null;
        }
    }

    public AnnotationType getAnnotation_type() {
        return this.annotation_type;
    }

    public BinaryAnnotation setAnnotation_type(AnnotationType annotationType) {
        this.annotation_type = annotationType;
        return this;
    }

    public void unsetAnnotation_type() {
        this.annotation_type = null;
    }

    public boolean isSetAnnotation_type() {
        return this.annotation_type != null;
    }

    public void setAnnotation_typeIsSet(boolean bl) {
        if (!bl) {
            this.annotation_type = null;
        }
    }

    public Endpoint getHost() {
        return this.host;
    }

    public BinaryAnnotation setHost(Endpoint endpoint) {
        this.host = endpoint;
        return this;
    }

    public void unsetHost() {
        this.host = null;
    }

    public boolean isSetHost() {
        return this.host != null;
    }

    public void setHostIsSet(boolean bl) {
        if (!bl) {
            this.host = null;
        }
    }

    public void setFieldValue(_Fields _Fields2, Object object) {
        switch (_Fields2) {
            case KEY: {
                if (object == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((String)object);
                break;
            }
            case VALUE: {
                if (object == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((ByteBuffer)object);
                break;
            }
            case ANNOTATION_TYPE: {
                if (object == null) {
                    this.unsetAnnotation_type();
                    break;
                }
                this.setAnnotation_type((AnnotationType)((Object)object));
                break;
            }
            case HOST: {
                if (object == null) {
                    this.unsetHost();
                    break;
                }
                this.setHost((Endpoint)object);
            }
        }
    }

    public Object getFieldValue(_Fields _Fields2) {
        switch (_Fields2) {
            case KEY: {
                return this.getKey();
            }
            case VALUE: {
                return this.getValue();
            }
            case ANNOTATION_TYPE: {
                return this.getAnnotation_type();
            }
            case HOST: {
                return this.getHost();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields _Fields2) {
        if (_Fields2 == null) {
            throw new IllegalArgumentException();
        }
        switch (_Fields2) {
            case KEY: {
                return this.isSetKey();
            }
            case VALUE: {
                return this.isSetValue();
            }
            case ANNOTATION_TYPE: {
                return this.isSetAnnotation_type();
            }
            case HOST: {
                return this.isSetHost();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof BinaryAnnotation) {
            return this.equals((BinaryAnnotation)object);
        }
        return false;
    }

    public boolean equals(BinaryAnnotation binaryAnnotation) {
        if (binaryAnnotation == null) {
            return false;
        }
        boolean bl = this.isSetKey();
        boolean bl2 = binaryAnnotation.isSetKey();
        if (bl || bl2) {
            if (!bl || !bl2) {
                return false;
            }
            if (!this.key.equals(binaryAnnotation.key)) {
                return false;
            }
        }
        boolean bl3 = this.isSetValue();
        boolean bl4 = binaryAnnotation.isSetValue();
        if (bl3 || bl4) {
            if (!bl3 || !bl4) {
                return false;
            }
            if (!this.value.equals(binaryAnnotation.value)) {
                return false;
            }
        }
        boolean bl5 = this.isSetAnnotation_type();
        boolean bl6 = binaryAnnotation.isSetAnnotation_type();
        if (bl5 || bl6) {
            if (!bl5 || !bl6) {
                return false;
            }
            if (!this.annotation_type.equals((Object)binaryAnnotation.annotation_type)) {
                return false;
            }
        }
        boolean bl7 = this.isSetHost();
        boolean bl8 = binaryAnnotation.isSetHost();
        if (bl7 || bl8) {
            if (!bl7 || !bl8) {
                return false;
            }
            if (!this.host.equals(binaryAnnotation.host)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(BinaryAnnotation binaryAnnotation) {
        if (!this.getClass().equals(binaryAnnotation.getClass())) {
            return this.getClass().getName().compareTo(binaryAnnotation.getClass().getName());
        }
        int n = 0;
        BinaryAnnotation binaryAnnotation2 = binaryAnnotation;
        n = Boolean.valueOf(this.isSetKey()).compareTo(binaryAnnotation2.isSetKey());
        if (n != 0) {
            return n;
        }
        if (this.isSetKey() && (n = TBaseHelper.compareTo((String)this.key, (String)binaryAnnotation2.key)) != 0) {
            return n;
        }
        n = Boolean.valueOf(this.isSetValue()).compareTo(binaryAnnotation2.isSetValue());
        if (n != 0) {
            return n;
        }
        if (this.isSetValue() && (n = TBaseHelper.compareTo((Comparable)this.value, (Comparable)binaryAnnotation2.value)) != 0) {
            return n;
        }
        n = Boolean.valueOf(this.isSetAnnotation_type()).compareTo(binaryAnnotation2.isSetAnnotation_type());
        if (n != 0) {
            return n;
        }
        if (this.isSetAnnotation_type() && (n = TBaseHelper.compareTo((Comparable)((Object)this.annotation_type), (Comparable)((Object)binaryAnnotation2.annotation_type))) != 0) {
            return n;
        }
        n = Boolean.valueOf(this.isSetHost()).compareTo(binaryAnnotation2.isSetHost());
        if (n != 0) {
            return n;
        }
        if (this.isSetHost() && (n = TBaseHelper.compareTo((Comparable)((Object)this.host), (Comparable)((Object)binaryAnnotation2.host))) != 0) {
            return n;
        }
        return 0;
    }

    public _Fields fieldForId(int n) {
        return _Fields.findByThriftId(n);
    }

    public void read(TProtocol tProtocol) throws TException {
        tProtocol.readStructBegin();
        while (true) {
            TField tField = tProtocol.readFieldBegin();
            if (tField.type == 0) break;
            switch (tField.id) {
                case 1: {
                    if (tField.type == 11) {
                        this.key = tProtocol.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)tProtocol, (byte)tField.type);
                    break;
                }
                case 2: {
                    if (tField.type == 11) {
                        this.value = tProtocol.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)tProtocol, (byte)tField.type);
                    break;
                }
                case 3: {
                    if (tField.type == 8) {
                        this.annotation_type = AnnotationType.findByValue(tProtocol.readI32());
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)tProtocol, (byte)tField.type);
                    break;
                }
                case 4: {
                    if (tField.type == 12) {
                        this.host = new Endpoint();
                        this.host.read(tProtocol);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)tProtocol, (byte)tField.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)tProtocol, (byte)tField.type);
                }
            }
            tProtocol.readFieldEnd();
        }
        tProtocol.readStructEnd();
        this.validate();
    }

    public void write(TProtocol tProtocol) throws TException {
        this.validate();
        tProtocol.writeStructBegin(STRUCT_DESC);
        if (this.key != null) {
            tProtocol.writeFieldBegin(KEY_FIELD_DESC);
            tProtocol.writeString(this.key);
            tProtocol.writeFieldEnd();
        }
        if (this.value != null) {
            tProtocol.writeFieldBegin(VALUE_FIELD_DESC);
            tProtocol.writeBinary(this.value);
            tProtocol.writeFieldEnd();
        }
        if (this.annotation_type != null) {
            tProtocol.writeFieldBegin(ANNOTATION_TYPE_FIELD_DESC);
            tProtocol.writeI32(this.annotation_type.getValue());
            tProtocol.writeFieldEnd();
        }
        if (this.host != null && this.isSetHost()) {
            tProtocol.writeFieldBegin(HOST_FIELD_DESC);
            this.host.write(tProtocol);
            tProtocol.writeFieldEnd();
        }
        tProtocol.writeFieldStop();
        tProtocol.writeStructEnd();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("BinaryAnnotation(");
        boolean bl = true;
        stringBuilder.append("key:");
        if (this.key == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(this.key);
        }
        bl = false;
        if (!bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("value:");
        if (this.value == null) {
            stringBuilder.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.value, (StringBuilder)stringBuilder);
        }
        bl = false;
        if (!bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("annotation_type:");
        if (this.annotation_type == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append((Object)this.annotation_type);
        }
        bl = false;
        if (this.isSetHost()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("host:");
            if (this.host == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(this.host);
            }
            bl = false;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void validate() throws TException {
    }

    static {
        EnumMap<_Fields, FieldMetaData> enumMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        enumMap.put(_Fields.KEY, new FieldMetaData("key", 3, new FieldValueMetaData(11)));
        enumMap.put(_Fields.VALUE, new FieldMetaData("value", 3, new FieldValueMetaData(11)));
        enumMap.put(_Fields.ANNOTATION_TYPE, new FieldMetaData("annotation_type", 3, (FieldValueMetaData)new EnumMetaData(16, AnnotationType.class)));
        enumMap.put(_Fields.HOST, new FieldMetaData("host", 2, (FieldValueMetaData)new StructMetaData(12, Endpoint.class)));
        metaDataMap = Collections.unmodifiableMap(enumMap);
        FieldMetaData.addStructMetaDataMap(BinaryAnnotation.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEY(1, "key"),
        VALUE(2, "value"),
        ANNOTATION_TYPE(3, "annotation_type"),
        HOST(4, "host");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int n) {
            switch (n) {
                case 1: {
                    return KEY;
                }
                case 2: {
                    return VALUE;
                }
                case 3: {
                    return ANNOTATION_TYPE;
                }
                case 4: {
                    return HOST;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int n) {
            _Fields _Fields2 = _Fields.findByThriftId(n);
            if (_Fields2 == null) {
                throw new IllegalArgumentException("Field " + n + " doesn't exist!");
            }
            return _Fields2;
        }

        public static _Fields findByName(String string) {
            return byName.get(string);
        }

        private _Fields(short s, String string2) {
            this._thriftId = s;
            this._fieldName = string2;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields _Fields2 : EnumSet.allOf(_Fields.class)) {
                byName.put(_Fields2.getFieldName(), _Fields2);
            }
        }
    }
}

