/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.jshell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.openjdk.tools.jshell.JShell;

class MemoryFileManager
implements JavaFileManager {
    private final StandardJavaFileManager stdFileManager;
    private final Map<String, OutputMemoryJavaFileObject> classObjects = new TreeMap<String, OutputMemoryJavaFileObject>();
    private ClassFileCreationListener classListener = null;
    private final ClassLoader loader = new REPLClassLoader();
    private final JShell proc;
    private Method inferModuleNameMethod = null;
    private Method listModuleLocationsMethod = null;

    Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location loc) {
        return this.stdFileManager.getLocationAsPaths(loc);
    }

    public MemoryFileManager(StandardJavaFileManager standardManager, JShell proc) {
        this.stdFileManager = standardManager;
        this.proc = proc;
    }

    private Collection<OutputMemoryJavaFileObject> generatedClasses() {
        return this.classObjects.values();
    }

    public void dumpClasses() {
        for (OutputMemoryJavaFileObject co : this.generatedClasses()) {
            co.dump();
        }
    }

    public Class<?> findGeneratedClass(String genClassFullName) throws ClassNotFoundException {
        for (OutputMemoryJavaFileObject co : this.generatedClasses()) {
            if (!co.className.equals(genClassFullName)) continue;
            Class<?> klass = this.loadClass(co.className);
            this.proc.debug(2, "Loaded %s\n", klass);
            return klass;
        }
        return null;
    }

    public byte[] findGeneratedBytes(String genClassFullName) throws ClassNotFoundException {
        for (OutputMemoryJavaFileObject co : this.generatedClasses()) {
            if (!co.className.equals(genClassFullName)) continue;
            return co.getBytes();
        }
        return null;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.getClassLoader(null).loadClass(name);
    }

    public JavaFileObject createSourceFileObject(Object origin, String name, String code) {
        return new SourceMemoryJavaFileObject(origin, name, code);
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) {
        try {
            if (this.inferModuleNameMethod == null) {
                this.inferModuleNameMethod = JavaFileManager.class.getDeclaredMethod("inferModuleName", JavaFileManager.Location.class);
            }
            String result = (String)this.inferModuleNameMethod.invoke((Object)this.stdFileManager, location);
            return result;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new InternalError("Cannot lookup JavaFileManager method", ex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new InternalError("Cannot invoke JavaFileManager method", ex);
        }
    }

    public Iterable<Set<JavaFileManager.Location>> listModuleLocations(JavaFileManager.Location location) throws IOException {
        try {
            if (this.listModuleLocationsMethod == null) {
                this.listModuleLocationsMethod = JavaFileManager.class.getDeclaredMethod("listModuleLocations", JavaFileManager.Location.class);
            }
            Iterable result = (Iterable)this.listModuleLocationsMethod.invoke((Object)this.stdFileManager, location);
            return result;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new InternalError("Cannot lookup JavaFileManager method", ex);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new InternalError("Cannot invoke JavaFileManager method", ex);
        }
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        this.proc.debug(2, "getClassLoader: location\n", location);
        return this.loader;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        final Iterable<JavaFileObject> stdList = this.stdFileManager.list(location, packageName, kinds, recurse);
        if (location == StandardLocation.CLASS_PATH && packageName.equals("REPL")) {
            return () -> new Iterator<JavaFileObject>(){
                boolean stdDone = false;
                Iterator it;

                @Override
                public boolean hasNext() {
                    if (this.it == null) {
                        this.it = stdList.iterator();
                    }
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (this.stdDone) {
                        return false;
                    }
                    this.stdDone = true;
                    this.it = MemoryFileManager.this.generatedClasses().iterator();
                    return this.it.hasNext();
                }

                @Override
                public JavaFileObject next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return (JavaFileObject)this.it.next();
                }
            };
        }
        return stdList;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof OutputMemoryJavaFileObject) {
            OutputMemoryJavaFileObject ofo = (OutputMemoryJavaFileObject)file;
            this.proc.debug(2, "inferBinaryName %s => %s\n", file, ofo.getName());
            return ofo.getName();
        }
        return this.stdFileManager.inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.stdFileManager.isSameFile(b, b);
    }

    @Override
    public int isSupportedOption(String option) {
        this.proc.debug(2, "isSupportedOption: %s\n", option);
        return this.stdFileManager.isSupportedOption(option);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        this.proc.debug(2, "handleOption: current: %s\n", current + ", remaining: " + remaining);
        return this.stdFileManager.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        this.proc.debug(2, "hasLocation: location: %s\n", location);
        return this.stdFileManager.hasLocation(location);
    }

    void registerClassFileCreationListener(ClassFileCreationListener listen) {
        this.classListener = listen;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.stdFileManager.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        OutputMemoryJavaFileObject fo = new OutputMemoryJavaFileObject(className, kind);
        this.classObjects.put(className, fo);
        this.proc.debug(2, "Set out file: %s = %s\n", className, fo);
        if (this.classListener != null) {
            this.classListener.newClassFile(fo, location, className, kind, sibling);
        }
        return fo;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        this.proc.debug(2, "getFileForInput location=%s packageName=%s\n", location, packageName);
        return this.stdFileManager.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        throw new UnsupportedOperationException("getFileForOutput: location: " + location + ", packageName: " + packageName + ", relativeName: " + relativeName + ", sibling: " + sibling);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    static interface ClassFileCreationListener {
        public void newClassFile(OutputMemoryJavaFileObject var1, JavaFileManager.Location var2, String var3, JavaFileObject.Kind var4, FileObject var5);
    }

    class REPLClassLoader
    extends ClassLoader {
        REPLClassLoader() {
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            OutputMemoryJavaFileObject fo = (OutputMemoryJavaFileObject)MemoryFileManager.this.classObjects.get(name);
            MemoryFileManager.this.proc.debug(2, "findClass %s = %s\n", name, fo);
            if (fo == null) {
                throw new ClassNotFoundException("Not ours");
            }
            byte[] b = fo.getBytes();
            return super.defineClass(name, b, 0, b.length, null);
        }
    }

    static class OutputMemoryJavaFileObject
    extends MemoryJavaFileObject {
        private ByteArrayOutputStream bos = new ByteArrayOutputStream();
        private byte[] bytes = null;
        private final String className;

        public OutputMemoryJavaFileObject(String name, JavaFileObject.Kind kind) {
            super(name, kind);
            this.className = name;
        }

        public byte[] getBytes() {
            if (this.bytes == null) {
                this.bytes = this.bos.toByteArray();
                this.bos = null;
            }
            return this.bytes;
        }

        public void dump() {
            try {
                Path dumpDir = FileSystems.getDefault().getPath("dump", new String[0]);
                if (Files.notExists(dumpDir, new LinkOption[0])) {
                    Files.createDirectory(dumpDir, new FileAttribute[0]);
                }
                Path file = FileSystems.getDefault().getPath("dump", this.getName() + ".class");
                Files.write(file, this.getBytes(), new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public String getName() {
            return this.className;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.bos;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }
    }

    class SourceMemoryJavaFileObject
    extends MemoryJavaFileObject {
        private final String src;
        private final Object origin;

        SourceMemoryJavaFileObject(Object origin, String className, String code) {
            super(className, JavaFileObject.Kind.SOURCE);
            this.origin = origin;
            this.src = code;
        }

        public Object getOrigin() {
            return this.origin;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.src;
        }
    }

    static abstract class MemoryJavaFileObject
    extends SimpleJavaFileObject {
        public MemoryJavaFileObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + name.replace('.', '/') + kind.extension), kind);
        }
    }
}

