/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.ext.io.StreamCopyException;

final class ByteArrayBlob
implements Blob {
    private final byte[] data;

    ByteArrayBlob(byte[] data) {
        this.data = data;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public void writeTo(OutputStream out) throws StreamCopyException {
        try {
            out.write(this.data);
        }
        catch (IOException ex) {
            throw new StreamCopyException(2, ex);
        }
    }

    @Override
    public long getSize() {
        return this.data.length;
    }
}

