/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.common.context.Info;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatasetInfo
extends Info
implements Comparable<DatasetInfo> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Integer, Set<IndexInfo>> partitionIndexes;
    private final Map<Long, IndexInfo> indexes;
    private final Int2IntMap partitionPendingIO;
    private final int datasetID;
    private final ILogManager logManager;
    private final LogRecord waitLog = new LogRecord();
    private int numActiveIOOps;
    private int pendingFlushes;
    private int pendingMerges;
    private int pendingReplications;
    private long lastAccess;
    private boolean isExternal;
    private boolean isRegistered;
    private boolean durable;

    public DatasetInfo(int datasetID, ILogManager logManager) {
        this.partitionIndexes = new HashMap<Integer, Set<IndexInfo>>();
        this.indexes = new HashMap<Long, IndexInfo>();
        this.partitionPendingIO = new Int2IntOpenHashMap();
        this.setLastAccess(-1L);
        this.datasetID = datasetID;
        this.setRegistered(false);
        this.logManager = logManager;
        this.waitLog.setLogType((byte)9);
        this.waitLog.computeAndSetLogSize();
    }

    @Override
    public void touch() {
        super.touch();
        this.setLastAccess(System.currentTimeMillis());
    }

    @Override
    public void untouch() {
        super.untouch();
        this.setLastAccess(System.currentTimeMillis());
    }

    public synchronized void declareActiveIOOperation(ILSMIOOperation.LSMIOOperationType opType, int partition) {
        this.partitionPendingIO.put(partition, this.partitionPendingIO.getOrDefault(partition, 0) + 1);
        ++this.numActiveIOOps;
        switch (opType) {
            case FLUSH: {
                ++this.pendingFlushes;
                break;
            }
            case MERGE: {
                ++this.pendingMerges;
                break;
            }
            case REPLICATE: {
                ++this.pendingReplications;
                break;
            }
        }
    }

    public synchronized void undeclareActiveIOOperation(ILSMIOOperation.LSMIOOperationType opType, int partition) {
        this.partitionPendingIO.put(partition, this.partitionPendingIO.getOrDefault(partition, 0) - 1);
        --this.numActiveIOOps;
        switch (opType) {
            case FLUSH: {
                --this.pendingFlushes;
                break;
            }
            case MERGE: {
                --this.pendingMerges;
                break;
            }
            case REPLICATE: {
                --this.pendingReplications;
                break;
            }
        }
        this.notifyAll();
    }

    public synchronized Set<ILSMIndex> getDatasetPartitionOpenIndexes(int partition) {
        HashSet<ILSMIndex> indexSet = new HashSet<ILSMIndex>();
        Set<IndexInfo> partitionIndexInfos = this.partitionIndexes.get(partition);
        if (partitionIndexInfos != null) {
            for (IndexInfo iInfo : partitionIndexInfos) {
                if (!iInfo.isOpen()) continue;
                indexSet.add(iInfo.getIndex());
            }
        }
        return indexSet;
    }

    @Override
    public int compareTo(DatasetInfo i) {
        if (this.isOpen() && !i.isOpen()) {
            return -1;
        }
        if (!this.isOpen() && i.isOpen()) {
            return 1;
        }
        if (this.getReferenceCount() < i.getReferenceCount()) {
            return -1;
        }
        if (this.getReferenceCount() > i.getReferenceCount()) {
            return 1;
        }
        if (this.getLastAccess() < i.getLastAccess()) {
            return -1;
        }
        if (this.getLastAccess() > i.getLastAccess()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatasetInfo) {
            return this.datasetID == ((DatasetInfo)obj).datasetID;
        }
        return false;
    }

    public int hashCode() {
        return this.datasetID;
    }

    public String toString() {
        return "DatasetID: " + this.getDatasetID() + ", isOpen: " + this.isOpen() + ", refCount: " + this.getReferenceCount() + ", lastAccess: " + this.getLastAccess() + ", isRegistered: " + this.isRegistered() + ", isDurable: " + this.isDurable();
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public synchronized Map<Long, IndexInfo> getIndexes() {
        return Collections.unmodifiableMap(this.indexes);
    }

    public synchronized void addIndex(long resourceID, IndexInfo indexInfo) {
        this.indexes.put(resourceID, indexInfo);
        this.partitionIndexes.computeIfAbsent(indexInfo.getPartition(), partition -> new HashSet()).add(indexInfo);
        LOGGER.debug("registered reference to index {}", (Object)indexInfo);
    }

    public synchronized void removeIndex(long resourceID) {
        IndexInfo info = this.indexes.remove(resourceID);
        if (info != null) {
            this.partitionIndexes.get(info.getPartition()).remove(info);
            LOGGER.debug("removed reference to index {}", (Object)info);
        }
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public int getDatasetID() {
        return this.datasetID;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIO() throws HyracksDataException {
        this.logManager.log(this.waitLog);
        DatasetInfo datasetInfo = this;
        synchronized (datasetInfo) {
            while (this.numActiveIOOps > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw HyracksDataException.create((Throwable)e);
                }
            }
            if (this.numActiveIOOps < 0) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Number of IO operations cannot be negative for dataset: " + this);
                }
                throw new IllegalStateException("Number of IO operations cannot be negative");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIO(int partition) throws HyracksDataException {
        this.logManager.log(this.waitLog);
        DatasetInfo datasetInfo = this;
        synchronized (datasetInfo) {
            while (this.partitionPendingIO.getOrDefault(partition, 0) > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw HyracksDataException.create((Throwable)e);
                }
            }
            if (this.partitionPendingIO.getOrDefault(partition, 0) < 0) {
                LOGGER.error("number of IO operations cannot be negative for dataset {}, partition {}", (Object)this, (Object)partition);
                throw new IllegalStateException("Number of IO operations cannot be negative: " + this + ", partition " + partition);
            }
        }
    }

    public synchronized int getPendingFlushes() {
        return this.pendingFlushes;
    }

    public synchronized int getPendingMerges() {
        return this.pendingMerges;
    }

    public synchronized int getPendingReplications() {
        return this.pendingReplications;
    }
}

