/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hyracks.util.ThreadDumpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ExitUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int EC_NORMAL_TERMINATION = 0;
    public static final int EC_ABNORMAL_TERMINATION = 1;
    public static final int EC_FAILED_TO_STARTUP = 2;
    public static final int EC_FAILED_TO_RECOVER = 3;
    public static final int EC_NC_FAILED_TO_ABORT_ALL_PREVIOUS_TASKS = 4;
    public static final int EC_FAILED_TO_PROCESS_UN_INTERRUPTIBLE_REQUEST = 5;
    public static final int EC_FAILED_TO_COMMIT_METADATA_TXN = 6;
    public static final int EC_FAILED_TO_ABORT_METADATA_TXN = 7;
    public static final int EC_INCONSISTENT_METADATA = 8;
    public static final int EC_UNCAUGHT_THROWABLE = 9;
    public static final int EC_HALT_UNHANDLED_EXCEPTION = 11;
    public static final int EC_FAILED_TO_DELETE_CORRUPTED_RESOURCES = 12;
    public static final int EC_ERROR_CREATING_RESOURCES = 13;
    public static final int EC_TXN_LOG_FLUSHER_FAILURE = 14;
    public static final int EC_NODE_REGISTRATION_FAILURE = 15;
    public static final int EC_NETWORK_FAILURE = 16;
    public static final int EC_ACTIVE_SUSPEND_FAILURE = 17;
    public static final int EC_ACTIVE_RESUME_FAILURE = 18;
    public static final int EC_NC_FAILED_TO_NOTIFY_TASKS_COMPLETED = 19;
    public static final int EC_ACTIVE_RECOVERY_FAILURE = 20;
    public static final int EC_FAILED_TO_CANCEL_ACTIVE_START_STOP = 22;
    public static final int EC_INCONSISTENT_STORAGE_REFERENCES = 23;
    public static final int EC_FAILED_TO_ROLLBACK_ATOMIC_STATEMENT = 24;
    public static final int EC_IMMEDIATE_HALT = 33;
    public static final int EC_HALT_ABNORMAL_RESERVED_44 = 44;
    public static final int EC_IO_SCHEDULER_FAILED = 55;
    public static final int EC_HALT_SHUTDOWN_TIMED_OUT = 66;
    public static final int EC_HALT_WATCHDOG_FAILED = 77;
    public static final int EC_IO_OPERATION_FAILED = 88;
    public static final int EC_TERMINATE_NC_SERVICE_DIRECTIVE = 99;
    private static final ExitThread exitThread = new ExitThread();
    private static final ShutdownWatchdog watchdogThread = new ShutdownWatchdog();
    private static final MutableLong shutdownHaltDelay = new MutableLong(600000L);
    private static final ExecutorService haltThreadDumpExecutor = Executors.newSingleThreadExecutor();
    private static final long HALT_THREADDUMP_TIMEOUT_SECONDS = 60L;

    private ExitUtil() {
    }

    public static void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(int status) {
        ExitThread exitThread = ExitUtil.exitThread;
        synchronized (exitThread) {
            if (ExitUtil.exitThread.isAlive()) {
                LOGGER.warn("ignoring duplicate request to exit with status " + status + "; already exiting with status " + ExitUtil.exitThread.status + "...");
            } else {
                ExitUtil.exitThread.setStatus(status, new Throwable("exit callstack"));
                ExitUtil.exitThread.start();
            }
        }
    }

    public static void exit(int status, long timeBeforeHalt, TimeUnit timeBeforeHaltUnit) {
        shutdownHaltDelay.setValue(timeBeforeHaltUnit.toMillis(timeBeforeHalt));
        ExitUtil.exit(status);
    }

    public static void halt(int status) {
        ExitUtil.halt(status, Level.FATAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void halt(int status, Level logLevel) {
        try {
            boolean interrupted = Thread.interrupted();
            LOGGER.log(logLevel, "JVM halting with status {} (halting thread {}, interrupted {})", (Object)status, (Object)Thread.currentThread(), (Object)interrupted);
            Future<?> future = haltThreadDumpExecutor.submit(() -> {
                LOGGER.log(logLevel, "Thread dump at halt: {}", (Object)ThreadDumpUtil.takeDumpString());
                LogManager.shutdown();
            });
            future.get(60L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.warn("exception logging thread dump on halt", (Throwable)e);
        }
        finally {
            Runtime.getRuntime().halt(status);
        }
    }

    public static boolean registerShutdownHook(Thread shutdownHook) {
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            LOGGER.info("successfully registered shutdown hook {}", (Object)shutdownHook);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("unable to register shutdown hook {}", (Object)shutdownHook, (Object)e);
            return false;
        }
    }

    public static boolean unregisterShutdownHook(Thread shutdownHook) {
        try {
            boolean success = Runtime.getRuntime().removeShutdownHook(shutdownHook);
            LOGGER.info("{}successfully removed shutdown hook {}", (Object)(success ? "" : "un"), (Object)shutdownHook);
            return success;
        }
        catch (IllegalStateException e) {
            LOGGER.log(Level.DEBUG, "ignoring exception while attempting to remove shutdown hook", (Throwable)e);
            return false;
        }
    }

    static {
        watchdogThread.start();
    }

    private static class ExitThread
    extends Thread {
        private volatile int status;
        private volatile Throwable callstack;

        ExitThread() {
            super("JVM exit thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            watchdogThread.beginWatch();
            try {
                LOGGER.warn("JVM exiting with status " + this.status + "; bye!", this.callstack);
                ExitThread.logShutdownHooks();
            }
            finally {
                Runtime.getRuntime().exit(this.status);
            }
        }

        public void setStatus(int status, Throwable callstack) {
            this.status = status;
            this.callstack = callstack;
        }

        private static void logShutdownHooks() {
            try {
                Class<?> clazz = Class.forName("java.lang.ApplicationShutdownHooks");
                Field hooksField = clazz.getDeclaredField("hooks");
                hooksField.setAccessible(true);
                IdentityHashMap hooks = (IdentityHashMap)hooksField.get(null);
                if (hooks != null) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = hooks::size;
                    supplierArray[1] = hooks::toString;
                    LOGGER.info("the following ({}) shutdown hooks have been registered: {}", supplierArray);
                }
            }
            catch (Exception e) {
                LOGGER.debug("ignoring exception trying to log shutdown hooks", (Throwable)e);
            }
        }
    }

    private static class ShutdownWatchdog
    extends Thread {
        private final Semaphore startSemaphore = new Semaphore(0);

        private ShutdownWatchdog() {
            super("ShutdownWatchdog");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block5: {
                this.startSemaphore.acquireUninterruptibly();
                LOGGER.info("starting shutdown watchdog- system will halt if shutdown is not completed within {} seconds", (Object)TimeUnit.MILLISECONDS.toSeconds(shutdownHaltDelay.getValue()));
                try {
                    exitThread.join(shutdownHaltDelay.getValue());
                    if (!exitThread.isAlive()) break block5;
                    try {
                        LOGGER.fatal("shutdown did not complete within configured delay; halting");
                    }
                    finally {
                        ExitUtil.halt(66);
                    }
                }
                catch (Throwable th) {
                    ExitUtil.halt(77);
                }
            }
        }

        public void beginWatch() {
            this.startSemaphore.release();
        }
    }
}

