/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.writer;

import org.apache.asterix.runtime.writer.IExternalFileWriter;
import org.apache.asterix.runtime.writer.IPathResolver;
import org.apache.hyracks.algebricks.runtime.writers.IExternalWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

final class ExternalWriter
implements IExternalWriter {
    static final String UNRESOLVABLE_PATH = "UNRESOLVABLE_PATH";
    private final IPathResolver pathResolver;
    private final IExternalFileWriter writer;
    private final int maxResultPerFile;
    private String partitionPath;
    private int tupleCounter;

    public ExternalWriter(IPathResolver pathResolver, IExternalFileWriter writer, int maxResultPerFile) {
        this.pathResolver = pathResolver;
        this.writer = writer;
        this.maxResultPerFile = maxResultPerFile;
    }

    public void open() throws HyracksDataException {
        this.writer.open();
    }

    public void initNewPartition(IFrameTupleReference tuple) throws HyracksDataException {
        this.partitionPath = this.pathResolver.getPartitionDirectory(tuple);
        if (UNRESOLVABLE_PATH != this.partitionPath) {
            this.writer.validate(this.partitionPath);
            this.newFile();
        }
    }

    public void write(IValueReference value) throws HyracksDataException {
        if (UNRESOLVABLE_PATH == this.partitionPath) {
            return;
        }
        this.writer.write(value);
        ++this.tupleCounter;
        if (this.tupleCounter >= this.maxResultPerFile) {
            this.newFile();
        }
    }

    public void abort() throws HyracksDataException {
        this.writer.abort();
    }

    public void close() throws HyracksDataException {
        this.writer.close();
    }

    private void newFile() throws HyracksDataException {
        this.tupleCounter = 0;
        if (!this.writer.newFile(this.partitionPath, this.pathResolver.getNextFileName())) {
            this.partitionPath = UNRESOLVABLE_PATH;
        }
    }
}

