/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADayTimeDuration;
import org.apache.asterix.om.base.AMutableDayTimeDuration;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.ADurationParserFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public abstract class AbstractDayTimeDurationConstructorEvaluator
extends AbstractConstructorEvaluator {
    private final AMutableDayTimeDuration aDayTimeDuration = new AMutableDayTimeDuration(0L);
    private final ISerializerDeserializer<ADayTimeDuration> dayTimeDurationSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADAYTIMEDURATION);
    private final UTF8StringPointable utf8Ptr = new UTF8StringPointable();

    protected AbstractDayTimeDurationConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case DAYTIMEDURATION: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case DURATION: {
                long millis = ADurationSerializerDeserializer.getDayTime((byte[])bytes, (int)(startOffset + 1));
                this.aDayTimeDuration.setMilliseconds(millis);
                this.resultStorage.reset();
                this.dayTimeDurationSerde.serialize((Object)this.aDayTimeDuration, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case STRING: {
                this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
                if (AbstractDayTimeDurationConstructorEvaluator.parseDayTimeDuration(this.utf8Ptr, (ADayTimeDuration)this.aDayTimeDuration)) {
                    this.resultStorage.reset();
                    this.dayTimeDurationSerde.serialize((Object)this.aDayTimeDuration, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    @Override
    protected final BuiltinType getTargetType() {
        return BuiltinType.ADAYTIMEDURATION;
    }

    private static boolean parseDayTimeDuration(UTF8StringPointable textPtr, ADayTimeDuration result) {
        try {
            ADurationParserFactory.parseDuration((byte[])textPtr.getByteArray(), (int)textPtr.getCharStartOffset(), (int)textPtr.getUTF8Length(), (IAObject)result, (ADurationParserFactory.ADurationParseOption)ADurationParserFactory.ADurationParseOption.DAY_TIME);
            return true;
        }
        catch (HyracksDataException e) {
            return false;
        }
    }
}

