/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestListWriter;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class ManifestLists {
    private ManifestLists() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<ManifestFile> read(InputFile manifestList) {
        try (AvroIterable files = Avro.read(manifestList).rename("manifest_file", GenericManifestFile.class.getName()).rename("partitions", GenericPartitionFieldSummary.class.getName()).rename("r508", GenericPartitionFieldSummary.class.getName()).classLoader(GenericManifestFile.class.getClassLoader()).project(ManifestFile.schema()).reuseContainers(false).build();){
            LinkedList linkedList = Lists.newLinkedList(files);
            return linkedList;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Cannot read manifest list file: %s", new Object[]{manifestList.location()});
        }
    }

    static ManifestListWriter write(int formatVersion, OutputFile manifestListFile, long snapshotId, Long parentSnapshotId, long sequenceNumber) {
        switch (formatVersion) {
            case 1: {
                Preconditions.checkArgument((sequenceNumber == 0L ? 1 : 0) != 0, (String)"Invalid sequence number for v1 manifest list: %s", (long)sequenceNumber);
                return new ManifestListWriter.V1Writer(manifestListFile, snapshotId, parentSnapshotId);
            }
            case 2: {
                return new ManifestListWriter.V2Writer(manifestListFile, snapshotId, parentSnapshotId, sequenceNumber);
            }
        }
        throw new UnsupportedOperationException("Cannot write manifest list for table version: " + formatVersion);
    }
}

