/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils.filter;

import java.util.List;
import java.util.Map;
import org.apache.asterix.column.filter.NoOpColumnFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.IColumnRangeFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessorFactory;
import org.apache.asterix.column.filter.range.accessor.ColumnRangeFilterValueAccessorFactory;
import org.apache.asterix.column.filter.range.accessor.ConstantColumnRangeFilterValueAccessorFactory;
import org.apache.asterix.column.filter.range.compartor.GEColumnFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.compartor.GTColumnFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.compartor.LEColumnFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.compartor.LTColumnFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.evaluator.ANDColumnFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.evaluator.ORColumnFilterEvaluatorFactory;
import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.projection.ColumnDatasetProjectionFiltrationInfo;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class ColumnRangeFilterBuilder {
    private final Map<ILogicalExpression, ARecordType> filterPaths;
    private final ILogicalExpression filterExpression;

    public ColumnRangeFilterBuilder(ColumnDatasetProjectionFiltrationInfo projectionFiltrationInfo) {
        this.filterPaths = projectionFiltrationInfo.getFilterPaths();
        this.filterExpression = projectionFiltrationInfo.getRangeFilterExpression();
    }

    public IColumnRangeFilterEvaluatorFactory build() {
        if (this.filterExpression == null || this.filterPaths.isEmpty()) {
            return NoOpColumnFilterEvaluatorFactory.INSTANCE;
        }
        return this.createEvaluator(this.filterPaths, this.filterExpression);
    }

    private IColumnRangeFilterEvaluatorFactory createEvaluator(Map<ILogicalExpression, ARecordType> filterPaths, ILogicalExpression filterExpression) {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)filterExpression;
        if (PushdownUtil.isFilterPath((ILogicalExpression)funcExpr) || PushdownUtil.isNot((ILogicalExpression)funcExpr)) {
            return this.createBooleanEvaluator(funcExpr, filterPaths);
        }
        if (PushdownUtil.isCompare((ILogicalExpression)funcExpr)) {
            return this.createComparator(funcExpr.getFunctionIdentifier(), funcExpr.getArguments(), filterPaths);
        }
        return this.createEvaluatorsForArgs(funcExpr, filterPaths);
    }

    private IColumnRangeFilterEvaluatorFactory createBooleanEvaluator(AbstractFunctionCallExpression funcExpr, Map<ILogicalExpression, ARecordType> filterPaths) {
        boolean not = PushdownUtil.isNot((ILogicalExpression)funcExpr);
        ABoolean constVal = not ? ABoolean.FALSE : ABoolean.TRUE;
        AbstractFunctionCallExpression pathExpr = not ? (ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue() : funcExpr;
        ARecordType path = filterPaths.get(pathExpr);
        return this.createComparator(BuiltinFunctions.EQ, path, (IAObject)constVal, true);
    }

    private IColumnRangeFilterEvaluatorFactory createComparator(FunctionIdentifier fid, List<Mutable<ILogicalExpression>> arguments, Map<ILogicalExpression, ARecordType> filterPaths) {
        IAObject constant;
        ARecordType path;
        ILogicalExpression left = (ILogicalExpression)arguments.get(0).getValue();
        ILogicalExpression right = (ILogicalExpression)arguments.get(1).getValue();
        boolean rightConstant = PushdownUtil.isConstant(right);
        if (rightConstant) {
            path = filterPaths.get(left);
            constant = ColumnRangeFilterBuilder.getConstant(right);
        } else {
            path = filterPaths.get(right);
            constant = ColumnRangeFilterBuilder.getConstant(left);
        }
        return this.createComparator(fid, path, constant, rightConstant);
    }

    private IColumnRangeFilterEvaluatorFactory createEvaluatorsForArgs(AbstractFunctionCallExpression funcExpr, Map<ILogicalExpression, ARecordType> filterPaths) {
        List args = funcExpr.getArguments();
        FunctionIdentifier fid = funcExpr.getFunctionIdentifier();
        IColumnRangeFilterEvaluatorFactory arg0 = this.createEvaluator(filterPaths, (ILogicalExpression)((Mutable)args.get(0)).getValue());
        IColumnRangeFilterEvaluatorFactory arg1 = this.createEvaluator(filterPaths, (ILogicalExpression)((Mutable)args.get(1)).getValue());
        IColumnRangeFilterEvaluatorFactory left = ColumnRangeFilterBuilder.createEvaluator(fid, arg0, arg1);
        for (int i = 2; i < args.size(); ++i) {
            IColumnRangeFilterEvaluatorFactory right = this.createEvaluator(filterPaths, (ILogicalExpression)((Mutable)args.get(i)).getValue());
            left = ColumnRangeFilterBuilder.createEvaluator(fid, left, right);
        }
        return left;
    }

    private IColumnRangeFilterEvaluatorFactory createComparator(FunctionIdentifier fid, ARecordType path, IAObject constant, boolean rightConstant) {
        ConstantColumnRangeFilterValueAccessorFactory constValue = ConstantColumnRangeFilterValueAccessorFactory.createFactory((IAObject)constant);
        if (path == null || constValue == null) {
            return NoOpColumnFilterEvaluatorFactory.INSTANCE;
        }
        AlgebricksBuiltinFunctions.ComparisonKind comparisonKind = this.getComparisonKind(fid, constant.getType().getTypeTag());
        if (comparisonKind == AlgebricksBuiltinFunctions.ComparisonKind.NEQ) {
            return NoOpColumnFilterEvaluatorFactory.INSTANCE;
        }
        ColumnRangeFilterValueAccessorFactory min = new ColumnRangeFilterValueAccessorFactory(path, true);
        ColumnRangeFilterValueAccessorFactory max = new ColumnRangeFilterValueAccessorFactory(path, false);
        if (rightConstant) {
            return ColumnRangeFilterBuilder.createEvaluator(comparisonKind, (IColumnRangeFilterValueAccessorFactory)min, (IColumnRangeFilterValueAccessorFactory)constValue, (IColumnRangeFilterValueAccessorFactory)max);
        }
        return ColumnRangeFilterBuilder.createEvaluator(ColumnRangeFilterBuilder.invert(comparisonKind), (IColumnRangeFilterValueAccessorFactory)min, (IColumnRangeFilterValueAccessorFactory)constValue, (IColumnRangeFilterValueAccessorFactory)max);
    }

    private AlgebricksBuiltinFunctions.ComparisonKind getComparisonKind(FunctionIdentifier fid, ATypeTag typeTag) {
        AlgebricksBuiltinFunctions.ComparisonKind comparisonKind = AlgebricksBuiltinFunctions.getComparisonType((FunctionIdentifier)fid);
        if (!NonTaggedFormatUtil.isFixedSizedCollection((ATypeTag)typeTag)) {
            if (comparisonKind == AlgebricksBuiltinFunctions.ComparisonKind.LT) {
                return AlgebricksBuiltinFunctions.ComparisonKind.LE;
            }
            if (comparisonKind == AlgebricksBuiltinFunctions.ComparisonKind.GT) {
                return AlgebricksBuiltinFunctions.ComparisonKind.GE;
            }
        }
        return comparisonKind;
    }

    private static IColumnRangeFilterEvaluatorFactory createEvaluator(FunctionIdentifier fid, IColumnRangeFilterEvaluatorFactory left, IColumnRangeFilterEvaluatorFactory right) {
        if (BuiltinFunctions.AND.equals((Object)fid)) {
            return new ANDColumnFilterEvaluatorFactory(left, right);
        }
        return new ORColumnFilterEvaluatorFactory(left, right);
    }

    private static AlgebricksBuiltinFunctions.ComparisonKind invert(AlgebricksBuiltinFunctions.ComparisonKind comparisonKind) {
        switch (comparisonKind) {
            case EQ: {
                return AlgebricksBuiltinFunctions.ComparisonKind.EQ;
            }
            case LE: {
                return AlgebricksBuiltinFunctions.ComparisonKind.GT;
            }
            case GE: {
                return AlgebricksBuiltinFunctions.ComparisonKind.LT;
            }
            case LT: {
                return AlgebricksBuiltinFunctions.ComparisonKind.GE;
            }
            case GT: {
                return AlgebricksBuiltinFunctions.ComparisonKind.LE;
            }
        }
        throw new IllegalStateException("Unsupported comparison type: " + comparisonKind);
    }

    private static IColumnRangeFilterEvaluatorFactory createEvaluator(AlgebricksBuiltinFunctions.ComparisonKind comparisonKind, IColumnRangeFilterValueAccessorFactory min, IColumnRangeFilterValueAccessorFactory constVal, IColumnRangeFilterValueAccessorFactory max) {
        if (comparisonKind == AlgebricksBuiltinFunctions.ComparisonKind.LT) {
            return new GTColumnFilterEvaluatorFactory(constVal, min);
        }
        if (comparisonKind == AlgebricksBuiltinFunctions.ComparisonKind.LE) {
            return new GEColumnFilterEvaluatorFactory(constVal, min);
        }
        if (comparisonKind == AlgebricksBuiltinFunctions.ComparisonKind.EQ) {
            GEColumnFilterEvaluatorFactory minComp = new GEColumnFilterEvaluatorFactory(constVal, min);
            LEColumnFilterEvaluatorFactory maxComp = new LEColumnFilterEvaluatorFactory(constVal, max);
            return new ANDColumnFilterEvaluatorFactory((IColumnRangeFilterEvaluatorFactory)minComp, (IColumnRangeFilterEvaluatorFactory)maxComp);
        }
        if (comparisonKind == AlgebricksBuiltinFunctions.ComparisonKind.GT) {
            return new LTColumnFilterEvaluatorFactory(constVal, max);
        }
        return new LEColumnFilterEvaluatorFactory(constVal, max);
    }

    private static IAObject getConstant(ILogicalExpression expr) {
        return ((AsterixConstantValue)((ConstantExpression)expr).getValue()).getObject();
    }
}

