/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class CreateSynonymStatement
extends AbstractStatement {
    private final Namespace namespace;
    private final String synonymName;
    private final Namespace objectNamespace;
    private final String objectName;
    private final boolean ifNotExists;

    public CreateSynonymStatement(Namespace namespace, String synonymName, Namespace objectNamespace, String objectName, boolean ifNotExists) {
        this.namespace = namespace;
        this.synonymName = synonymName;
        this.objectNamespace = objectNamespace;
        this.objectName = objectName;
        this.ifNotExists = ifNotExists;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public String getSynonymName() {
        return this.synonymName;
    }

    public Namespace getObjectNamespace() {
        return this.objectNamespace;
    }

    public DataverseName getObjectDataverseName() {
        return this.objectNamespace == null ? null : this.objectNamespace.getDataverseName();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_SYNONYM;
    }

    @Override
    public byte getCategory() {
        return 4;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }
}

