/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.writer;

import java.io.IOException;
import org.apache.asterix.column.bytes.encoder.ParquetPlainFixedLengthValuesWriter;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.writer.AbstractColumnValuesWriter;
import org.apache.asterix.column.values.writer.filters.AbstractColumnFilterWriter;
import org.apache.asterix.column.values.writer.filters.DoubleColumnFilterWriter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.parquet.bytes.BytesInput;

public final class DoubleColumnValuesWriter
extends AbstractColumnValuesWriter {
    private final ParquetPlainFixedLengthValuesWriter doubleWriter;

    public DoubleColumnValuesWriter(Mutable<IColumnWriteMultiPageOp> multiPageOpRef, int columnIndex, int level, boolean collection, boolean filtered) {
        super(columnIndex, level, collection, filtered);
        this.doubleWriter = new ParquetPlainFixedLengthValuesWriter(multiPageOpRef);
    }

    @Override
    protected void addValue(ATypeTag tag, IValueReference value) throws IOException {
        double normalizedDouble = this.getValue(tag, value.getByteArray(), value.getStartOffset());
        this.doubleWriter.writeDouble(normalizedDouble);
        this.filterWriter.addDouble(normalizedDouble);
    }

    private double getValue(ATypeTag typeTag, byte[] byteArray, int offset) {
        switch (typeTag) {
            case TINYINT: {
                return byteArray[offset];
            }
            case SMALLINT: {
                return ShortPointable.getShort((byte[])byteArray, (int)offset);
            }
            case INTEGER: {
                return IntegerPointable.getInteger((byte[])byteArray, (int)offset);
            }
            case BIGINT: {
                return LongPointable.getLong((byte[])byteArray, (int)offset);
            }
            case FLOAT: {
                return FloatPointable.getFloat((byte[])byteArray, (int)offset);
            }
            case DOUBLE: {
                return DoublePointable.getDouble((byte[])byteArray, (int)offset);
            }
        }
        throw new IllegalAccessError(typeTag + "is not of floating type");
    }

    @Override
    protected void resetValues() throws HyracksDataException {
        this.doubleWriter.reset();
    }

    @Override
    protected BytesInput getBytes() throws IOException {
        return this.doubleWriter.getBytes();
    }

    @Override
    protected int getValuesEstimatedSize() {
        return this.doubleWriter.getEstimatedSize();
    }

    @Override
    protected int calculateEstimatedSize(int length) {
        return this.doubleWriter.calculateEstimatedSize(length);
    }

    @Override
    protected int getValuesAllocatedSize() {
        return this.doubleWriter.getAllocatedSize();
    }

    @Override
    protected void addValue(IColumnValuesReader reader) throws IOException {
        double value = reader.getDouble();
        this.doubleWriter.writeDouble(value);
        this.filterWriter.addDouble(value);
    }

    @Override
    protected AbstractColumnFilterWriter createFilter() {
        return new DoubleColumnFilterWriter();
    }

    @Override
    protected void closeValues() {
        this.doubleWriter.close();
    }

    @Override
    protected ATypeTag getTypeTag() {
        return ATypeTag.DOUBLE;
    }
}

