/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.reader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Arrays;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.asterix.column.values.reader.AbstractColumnValuesReader;
import org.apache.asterix.column.values.reader.value.AbstractValueReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.column.error.ColumnarValueException;

public final class RepeatedPrimitiveColumnValuesReader
extends AbstractColumnValuesReader {
    private final int[] delimiters;
    private final int[] levelToDelimiterMap;
    private int delimiterIndex;

    RepeatedPrimitiveColumnValuesReader(AbstractValueReader valueReader, int columnIndex, int maxLevel, int[] delimiters) {
        super(valueReader, columnIndex, maxLevel, false);
        this.delimiters = delimiters;
        this.delimiterIndex = delimiters.length;
        this.levelToDelimiterMap = new int[maxLevel + 1];
        int currentDelimiterIndex = 0;
        for (int level = maxLevel; level >= 0; --level) {
            if (currentDelimiterIndex >= delimiters.length || level == delimiters[currentDelimiterIndex]) {
                // empty if block
            }
            this.levelToDelimiterMap[level] = ++currentDelimiterIndex;
        }
    }

    @Override
    protected void resetValues() {
        this.delimiterIndex = this.delimiters.length;
    }

    @Override
    public boolean next() throws HyracksDataException {
        if (this.valueIndex == this.valueCount) {
            return false;
        }
        this.consumeDelimiterIfAny();
        this.nextLevel();
        this.setDelimiterIndex();
        if (this.level == this.maxLevel) {
            this.valueReader.nextValue();
        }
        return true;
    }

    @Override
    public boolean isRepeated() {
        return true;
    }

    @Override
    public boolean isDelimiter() {
        return this.delimiterIndex < this.delimiters.length && this.level == this.delimiters[this.delimiterIndex];
    }

    @Override
    public int getNumberOfDelimiters() {
        return this.delimiters.length;
    }

    @Override
    public int getDelimiterIndex() {
        return this.delimiterIndex;
    }

    @Override
    public void write(IColumnValuesWriter writer, boolean callNext) throws HyracksDataException {
        if (!this.next()) {
            ColumnarValueException e = new ColumnarValueException();
            this.appendReaderInformation(e.createNode(this.getClass().getSimpleName()));
            throw e;
        }
        if (this.isRepeatedValue()) {
            while (!this.isLastDelimiter()) {
                writer.writeLevel(this.level);
                if (this.isValue()) {
                    try {
                        writer.writeValue(this);
                    }
                    catch (IOException e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
                this.next();
            }
        }
        writer.writeLevel(this.level);
    }

    @Override
    public boolean isRepeatedValue() {
        return this.levelToDelimiterMap[this.level] < this.delimiters.length;
    }

    @Override
    public boolean isLastDelimiter() {
        return this.isDelimiter() && this.delimiterIndex == this.delimiters.length - 1;
    }

    @Override
    public void skip(int count) throws HyracksDataException {
        for (int i = 0; i < count; ++i) {
            this.next();
            if (!this.isRepeatedValue()) continue;
            while (!this.isLastDelimiter()) {
                this.next();
            }
        }
    }

    private void consumeDelimiterIfAny() {
        if (this.isDelimiter()) {
            ++this.delimiterIndex;
        }
    }

    private void setDelimiterIndex() {
        if (this.isDelimiter() || this.level <= this.delimiters[this.delimiters.length - 1]) {
            return;
        }
        this.delimiterIndex = this.levelToDelimiterMap[this.level];
    }

    @Override
    public void appendReaderInformation(ObjectNode node) {
        this.appendCommon(node);
        node.put("delimiters", Arrays.toString(this.delimiters));
        node.put("levelToDelimiterMap", Arrays.toString(this.levelToDelimiterMap));
        node.put("delimiterIndex", this.delimiterIndex);
        node.put("isDelimiter", this.isDelimiter());
    }
}

