/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler;

import org.apache.asterix.column.assembler.AbstractNestedValueAssembler;
import org.apache.asterix.column.assembler.AbstractValueAssembler;
import org.apache.asterix.column.assembler.AssemblerInfo;
import org.apache.asterix.column.assembler.AssemblerState;
import org.apache.asterix.column.assembler.value.IValueGetter;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

public abstract class AbstractPrimitiveValueAssembler
extends AbstractValueAssembler {
    public static final int NEXT_ASSEMBLER = -1;
    protected final IValueGetter primitiveValueGetter;
    protected final IColumnValuesReader reader;

    AbstractPrimitiveValueAssembler(int level, AssemblerInfo info, IColumnValuesReader reader, IValueGetter primitiveValueGetter) {
        super(level, info);
        this.primitiveValueGetter = primitiveValueGetter;
        this.reader = reader;
    }

    @Override
    public final IValueReference getValue() throws HyracksDataException {
        return this.primitiveValueGetter.getValue(this.reader);
    }

    @Override
    void addNullToAncestor(int nullLevel) throws HyracksDataException {
        AbstractNestedValueAssembler parent = this.getParent();
        if (nullLevel + 1 == this.level) {
            parent.start();
            parent.addNull(this);
            return;
        }
        parent.addNullToAncestor(nullLevel);
    }

    @Override
    void addMissingToAncestor(int missingLevel) throws HyracksDataException {
        AbstractNestedValueAssembler parent = this.getParent();
        if (missingLevel + 1 == this.level) {
            parent.start();
            parent.addMissing();
            return;
        }
        parent.addMissingToAncestor(missingLevel);
    }

    @Override
    final void addValueToParent() throws HyracksDataException {
        AbstractNestedValueAssembler parent = this.getParent();
        parent.start();
        this.getParent().addValue(this);
    }

    public final int getColumnIndex() {
        return this.reader.getColumnIndex();
    }

    public void skip(int count) throws HyracksDataException {
        this.reader.skip(count);
    }

    public abstract void reset(AbstractBytesInputStream var1, int var2) throws HyracksDataException;

    public abstract int next(AssemblerState var1) throws HyracksDataException;
}

