/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnMetadata;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTree;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.LSMColumnBTree;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.LSMColumnBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.LSMColumnIndexBulkloader;
import org.apache.hyracks.storage.am.lsm.btree.column.utils.ColumnUtil;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBloomFilterDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.ChainedLSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;

public class LSMColumnBTreeWithBloomFilterDiskComponent
extends LSMBTreeWithBloomFilterDiskComponent {
    public LSMColumnBTreeWithBloomFilterDiskComponent(AbstractLSMIndex lsmIndex, BTree btree, BloomFilter bloomFilter, ILSMComponentFilter filter) {
        super(lsmIndex, btree, bloomFilter, filter);
    }

    public ChainedLSMDiskComponentBulkLoader createBulkLoader(ILSMIOOperation operation, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean withFilter, boolean cleanupEmptyComponent, IPageWriteCallback callback) throws HyracksDataException {
        ChainedLSMDiskComponentBulkLoader chainedBulkLoader = new ChainedLSMDiskComponentBulkLoader(operation, (ILSMDiskComponent)this, cleanupEmptyComponent);
        if (withFilter && this.getLsmIndex().getFilterFields() != null) {
            chainedBulkLoader.addBulkLoader(this.createFilterBulkLoader());
        }
        chainedBulkLoader.addBulkLoader(this.createColumnIndexBulkLoader(operation, fillFactor, verifyInput, callback));
        if (numElementsHint > 0L) {
            chainedBulkLoader.addBulkLoader(this.createBloomFilterBulkLoader(numElementsHint, callback));
        }
        callback.initialize((IIndexBulkLoader)chainedBulkLoader);
        return chainedBulkLoader;
    }

    private IChainedComponentBulkLoader createColumnIndexBulkLoader(ILSMIOOperation operation, float fillFactor, boolean verifyInput, IPageWriteCallback callback) throws HyracksDataException {
        IColumnMetadata columnMetadata;
        ILSMIOOperation.LSMIOOperationType operationType = operation.getIOOpertionType();
        LSMColumnBTree lsmColumnBTree = (LSMColumnBTree)this.getLsmIndex();
        ColumnBTree columnBTree = (ColumnBTree)this.getIndex();
        if (operationType == ILSMIOOperation.LSMIOOperationType.FLUSH || operationType == ILSMIOOperation.LSMIOOperationType.LOAD) {
            columnMetadata = lsmColumnBTree.getColumnMetadata();
        } else {
            LSMBTreeMergeOperation mergeOp = (LSMBTreeMergeOperation)operation;
            LSMColumnBTreeRangeSearchCursor cursor = (LSMColumnBTreeRangeSearchCursor)mergeOp.getCursor();
            List mergingComponents = mergeOp.getMergingComponents();
            IComponentMetadata componentMetadata = ((ILSMComponent)mergingComponents.get(0)).getMetadata();
            IValueReference columnMetadataValue = ColumnUtil.getColumnMetadataCopy(componentMetadata);
            columnMetadata = lsmColumnBTree.getColumnManager().createMergeColumnMetadata(columnMetadataValue, cursor.getComponentTupleList());
        }
        IIndexBulkLoader bulkLoader = columnBTree.createBulkLoader(fillFactor, verifyInput, callback, columnMetadata);
        return new LSMColumnIndexBulkloader(bulkLoader, columnMetadata, (IComponentMetadata)this.getMetadata());
    }
}

