/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.btree;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.DiskBTree;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnMetadata;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnProjectionInfo;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeBulkloader;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeLeafFrameFactory;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeReadLeafFrame;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeWriteLeafFrame;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.NoOpIndexCursorStats;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;

public class ColumnBTree
extends DiskBTree {
    public ColumnBTree(IBufferCache bufferCache, IPageManager freePageManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory, IBinaryComparatorFactory[] cmpFactories, int fieldCount, FileReference file) {
        super(bufferCache, freePageManager, interiorFrameFactory, leafFrameFactory, cmpFactories, fieldCount, file);
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, IPageWriteCallback callback) {
        throw new IllegalAccessError("Missing write column metadata");
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, IPageWriteCallback callback, IColumnMetadata columnMetadata) throws HyracksDataException {
        ColumnBTreeLeafFrameFactory columnLeafFrameFactory = (ColumnBTreeLeafFrameFactory)this.leafFrameFactory;
        ColumnBTreeWriteLeafFrame writeLeafFrame = columnLeafFrameFactory.createWriterFrame(columnMetadata);
        return new ColumnBTreeBulkloader(fillFactor, verifyInput, callback, (ITreeIndex)this, writeLeafFrame);
    }

    public BTree.BTreeAccessor createAccessor(IIndexAccessParameters iap) {
        throw new IllegalArgumentException("Use createAccessor(IIndexAccessParameters, int, IColumnTupleProjector)");
    }

    public BTree.BTreeAccessor createAccessor(IIndexAccessParameters iap, int index, IColumnProjectionInfo projectionInfo) {
        return new ColumnBTreeAccessor(this, iap, index, projectionInfo);
    }

    public class ColumnBTreeAccessor
    extends DiskBTree.DiskBTreeAccessor {
        private final int index;
        private final IColumnProjectionInfo projectionInfo;

        public ColumnBTreeAccessor(ColumnBTree btree, IIndexAccessParameters iap, int index, IColumnProjectionInfo projectionInfo) {
            super((DiskBTree)ColumnBTree.this, (DiskBTree)btree, iap);
            this.index = index;
            this.projectionInfo = projectionInfo;
        }

        public ITreeIndexCursor createSearchCursor(boolean exclusive) {
            ColumnBTreeLeafFrameFactory columnLeafFrameFactory = (ColumnBTreeLeafFrameFactory)ColumnBTree.this.leafFrameFactory;
            ColumnBTreeReadLeafFrame readLeafFrame = columnLeafFrameFactory.createReadFrame(this.projectionInfo);
            return new ColumnBTreeRangeSearchCursor(readLeafFrame, this.iap.getParameters().getOrDefault("INDEX_CURSOR_STATS", NoOpIndexCursorStats.INSTANCE), this.index);
        }

        public ITreeIndexCursor createPointCursor(boolean exclusive, boolean stateful) {
            ColumnBTreeLeafFrameFactory columnLeafFrameFactory = (ColumnBTreeLeafFrameFactory)ColumnBTree.this.leafFrameFactory;
            ColumnBTreeReadLeafFrame readLeafFrame = columnLeafFrameFactory.createReadFrame(this.projectionInfo);
            return new ColumnBTreePointSearchCursor(readLeafFrame, this.iap.getParameters().getOrDefault("INDEX_CURSOR_STATS", NoOpIndexCursorStats.INSTANCE), this.index);
        }
    }
}

