/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.noop.NoopMeter;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import reactor.netty.Metrics;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.MeterKey;
import reactor.netty.internal.util.MapUtils;
import reactor.util.annotation.Nullable;

public class MicrometerChannelMetricsRecorder
implements ChannelMetricsRecorder {
    static final String ADDRESS_RESOLVER_TIME_DESCRIPTION = "Time spent for resolving the address";
    protected static final String BYTES_UNIT = "bytes";
    static final String CONNECT_TIME_DESCRIPTION = "Time spent for connecting to the remote address";
    protected static final String DATA_RECEIVED_DESCRIPTION = "Amount of the data received, in bytes";
    protected static final String DATA_SENT_DESCRIPTION = "Amount of the data sent, in bytes";
    protected static final String ERRORS_DESCRIPTION = "Number of errors that occurred";
    static final String TLS_HANDSHAKE_TIME_DESCRIPTION = "Time spent for TLS handshake";
    static final String TOTAL_CONNECTIONS_DESCRIPTION = "The number of all opened connections";
    final ConcurrentMap<String, DistributionSummary> dataReceivedCache = new ConcurrentHashMap<String, DistributionSummary>();
    final ConcurrentMap<String, DistributionSummary> dataSentCache = new ConcurrentHashMap<String, DistributionSummary>();
    final ConcurrentMap<String, Counter> errorsCache = new ConcurrentHashMap<String, Counter>();
    final ConcurrentMap<MeterKey, Timer> connectTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final ConcurrentMap<MeterKey, Timer> tlsHandshakeTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final ConcurrentMap<MeterKey, Timer> addressResolverTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final ConcurrentMap<String, LongAdder> totalConnectionsCache = new ConcurrentHashMap<String, LongAdder>();
    final String name;
    final String protocol;

    public MicrometerChannelMetricsRecorder(String name, String protocol) {
        this.name = name;
        this.protocol = protocol;
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        DistributionSummary ds = MapUtils.computeIfAbsent(this.dataReceivedCache, address, key -> MicrometerChannelMetricsRecorder.filter(DistributionSummary.builder((String)(this.name + ".data.received")).baseUnit(BYTES_UNIT).description(DATA_RECEIVED_DESCRIPTION).tags(new String[]{"uri", this.protocol, "remote.address", address}).register(Metrics.REGISTRY)));
        if (ds != null) {
            ds.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        DistributionSummary ds = MapUtils.computeIfAbsent(this.dataSentCache, address, key -> MicrometerChannelMetricsRecorder.filter(DistributionSummary.builder((String)(this.name + ".data.sent")).baseUnit(BYTES_UNIT).description(DATA_SENT_DESCRIPTION).tags(new String[]{"uri", this.protocol, "remote.address", address}).register(Metrics.REGISTRY)));
        if (ds != null) {
            ds.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Counter c = MapUtils.computeIfAbsent(this.errorsCache, address, key -> MicrometerChannelMetricsRecorder.filter(Counter.builder((String)(this.name + ".errors")).description(ERRORS_DESCRIPTION).tags(new String[]{"uri", this.protocol, "remote.address", address}).register(Metrics.REGISTRY)));
        if (c != null) {
            c.increment();
        }
    }

    @Override
    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(null, address, null, status);
        Timer timer = MapUtils.computeIfAbsent(this.tlsHandshakeTimeCache, meterKey, key -> MicrometerChannelMetricsRecorder.filter(Timer.builder((String)(this.name + ".tls.handshake.time")).description(TLS_HANDSHAKE_TIME_DESCRIPTION).tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
        if (timer != null) {
            timer.record(time);
        }
    }

    @Override
    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(null, address, null, status);
        Timer timer = MapUtils.computeIfAbsent(this.connectTimeCache, meterKey, key -> MicrometerChannelMetricsRecorder.filter(Timer.builder((String)(this.name + ".connect.time")).description(CONNECT_TIME_DESCRIPTION).tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
        if (timer != null) {
            timer.record(time);
        }
    }

    @Override
    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(null, address, null, status);
        Timer timer = MapUtils.computeIfAbsent(this.addressResolverTimeCache, meterKey, key -> MicrometerChannelMetricsRecorder.filter(Timer.builder((String)(this.name + ".address.resolver")).description(ADDRESS_RESOLVER_TIME_DESCRIPTION).tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
        if (timer != null) {
            timer.record(time);
        }
    }

    @Override
    public void recordServerConnectionOpened(SocketAddress serverAddress) {
        LongAdder totalConnectionAdder = this.getTotalConnectionsAdder(serverAddress);
        if (totalConnectionAdder != null) {
            totalConnectionAdder.increment();
        }
    }

    @Override
    public void recordServerConnectionClosed(SocketAddress serverAddress) {
        LongAdder totalConnectionAdder = this.getTotalConnectionsAdder(serverAddress);
        if (totalConnectionAdder != null) {
            totalConnectionAdder.decrement();
        }
    }

    @Nullable
    protected static <M extends Meter> M filter(M meter) {
        if (meter instanceof NoopMeter) {
            return null;
        }
        return meter;
    }

    protected String name() {
        return this.name;
    }

    protected String protocol() {
        return this.protocol;
    }

    @Nullable
    LongAdder getTotalConnectionsAdder(SocketAddress serverAddress) {
        String address = Metrics.formatSocketAddress(serverAddress);
        return MapUtils.computeIfAbsent(this.totalConnectionsCache, address, key -> {
            LongAdder totalConnectionsAdder = new LongAdder();
            Gauge gauge = MicrometerChannelMetricsRecorder.filter(Gauge.builder((String)(this.name + ".connections.total"), (Object)totalConnectionsAdder, LongAdder::longValue).description(TOTAL_CONNECTIONS_DESCRIPTION).tags(new String[]{"uri", this.protocol, "local.address", address}).register(Metrics.REGISTRY));
            return gauge != null ? totalConnectionsAdder : null;
        });
    }
}

