/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.processor;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.processor.AbstractPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.visitor.ExpectedSchemaMergerVisitor;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.AllVariablesSubstituteVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class ConsolidateProjectionAndFilterExpressionsProcessor
extends AbstractPushdownProcessor {
    private final AllVariablesSubstituteVisitor substituteVisitor = new AllVariablesSubstituteVisitor();
    private final ExpectedSchemaMergerVisitor schemaMergerVisitor = new ExpectedSchemaMergerVisitor();

    public ConsolidateProjectionAndFilterExpressionsProcessor(PushdownContext pushdownContext, IOptimizationContext context) {
        super(pushdownContext, context);
    }

    @Override
    public boolean process() throws AlgebricksException {
        boolean changed = false;
        Collection<List<ScanDefineDescriptor>> scanDescriptors = this.pushdownContext.getDatasetToScanDefinitionDescriptors().values();
        for (List<ScanDefineDescriptor> descriptors : scanDescriptors) {
            changed |= this.consolidate(descriptors);
        }
        return changed;
    }

    private boolean consolidate(List<ScanDefineDescriptor> scanDefineDescriptors) throws AlgebricksException {
        if (scanDefineDescriptors.size() <= 1) {
            return false;
        }
        HashMap<ILogicalExpression, ARecordType> paths = new HashMap<ILogicalExpression, ARecordType>();
        HashMap<String, FunctionCallInformation> sourceInformationMap = new HashMap<String, FunctionCallInformation>();
        ConstantExpression rangeFilterExpr = ConstantExpression.TRUE;
        ConstantExpression filterExpr = ConstantExpression.TRUE;
        RootExpectedSchemaNode mergedRoot = null;
        RootExpectedSchemaNode mergedMetaRoot = null;
        for (ScanDefineDescriptor descriptor : scanDefineDescriptors) {
            Map<ILogicalExpression, ARecordType> scanPaths = descriptor.getFilterPaths();
            paths.putAll(scanPaths);
            sourceInformationMap.putAll(descriptor.getPathLocations());
            rangeFilterExpr = this.or((ILogicalExpression)rangeFilterExpr, descriptor.getRangeFilterExpression());
            filterExpr = this.or((ILogicalExpression)filterExpr, descriptor.getFilterExpression());
            mergedRoot = this.schemaMergerVisitor.merge(mergedRoot, descriptor.getRecordNode());
            mergedMetaRoot = this.schemaMergerVisitor.merge(mergedMetaRoot, descriptor.getMetaNode());
        }
        for (ScanDefineDescriptor descriptor : scanDefineDescriptors) {
            Map<ILogicalExpression, ARecordType> descriptorPaths = descriptor.getFilterPaths();
            LogicalVariable scanVariable = descriptor.getVariable();
            descriptorPaths.clear();
            this.cloneAndSubstituteVariable(scanVariable, paths, descriptorPaths);
            Map<String, FunctionCallInformation> decsriptorSourceInformationMap = descriptor.getPathLocations();
            decsriptorSourceInformationMap.putAll(sourceInformationMap);
            descriptor.setRangeFilterExpression(this.cloneAndSubstituteVariable(scanVariable, (ILogicalExpression)rangeFilterExpr));
            descriptor.setFilterExpression(this.cloneAndSubstituteVariable(scanVariable, (ILogicalExpression)filterExpr));
            descriptor.setRecordNode(mergedRoot);
            descriptor.setMetaNode(mergedMetaRoot);
        }
        return true;
    }

    private AbstractFunctionCallExpression or(ILogicalExpression mergedExpr, ILogicalExpression expr) {
        AbstractFunctionCallExpression orExpr;
        if (expr == null || mergedExpr == null) {
            return null;
        }
        AbstractFunctionCallExpression abstractFunctionCallExpression = orExpr = mergedExpr == ConstantExpression.TRUE ? null : (AbstractFunctionCallExpression)mergedExpr;
        if (orExpr == null) {
            MetadataProvider metadataProvider = (MetadataProvider)this.context.getMetadataProvider();
            IFunctionInfo fInfo = metadataProvider.lookupFunction(BuiltinFunctions.OR);
            orExpr = new ScalarFunctionCallExpression(fInfo);
        }
        orExpr.getArguments().add(new MutableObject((Object)expr));
        return orExpr;
    }

    private void cloneAndSubstituteVariable(LogicalVariable scanVariable, Map<ILogicalExpression, ARecordType> src, Map<ILogicalExpression, ARecordType> dest) throws AlgebricksException {
        for (Map.Entry<ILogicalExpression, ARecordType> srcEntry : src.entrySet()) {
            ILogicalExpression substitutedExpr = srcEntry.getKey().cloneExpression();
            substitutedExpr.accept((ILogicalExpressionVisitor)this.substituteVisitor, (Object)scanVariable);
            dest.put(substitutedExpr, srcEntry.getValue());
        }
    }

    private ILogicalExpression cloneAndSubstituteVariable(LogicalVariable scanVariable, ILogicalExpression expression) throws AlgebricksException {
        if (expression == null) {
            return null;
        }
        ILogicalExpression clonedExpr = expression.cloneExpression();
        clonedExpr.accept((ILogicalExpressionVisitor)this.substituteVisitor, (Object)scanVariable);
        return clonedExpr;
    }
}

