/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.cost;

import java.util.Map;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.optimizer.cost.Cost;
import org.apache.asterix.optimizer.cost.ICostMethods;
import org.apache.asterix.optimizer.rules.cbo.JoinNode;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;

public class CostMethods
implements ICostMethods {
    protected IOptimizationContext optCtx;
    protected PhysicalOptimizationConfig physOptConfig;
    protected long blockSize;
    protected long DOP;
    protected static double selectivityForSecondaryIndexSelection = 0.1;
    protected double maxMemorySizeForJoin;
    protected double maxMemorySizeForGroup;
    protected double maxMemorySizeForSort;

    public CostMethods(IOptimizationContext context) {
        this.setContext(context);
    }

    @Override
    public void setContext(IOptimizationContext context) {
        this.optCtx = context;
        this.physOptConfig = context.getPhysicalOptimizationConfig();
        this.blockSize = this.getBufferCachePageSize();
        this.DOP = this.getDOP();
        this.maxMemorySizeForJoin = this.getMaxMemorySizeForJoin();
        this.maxMemorySizeForGroup = this.getMaxMemorySizeForGroup();
        this.maxMemorySizeForSort = this.getMaxMemorySizeForSort();
    }

    private long getBufferCacheSize() {
        MetadataProvider metadataProvider = (MetadataProvider)this.optCtx.getMetadataProvider();
        return metadataProvider.getStorageProperties().getBufferCacheSize();
    }

    public long getBufferCachePageSize() {
        MetadataProvider metadataProvider = (MetadataProvider)this.optCtx.getMetadataProvider();
        return metadataProvider.getStorageProperties().getBufferCachePageSize();
    }

    public long getDOP() {
        return this.optCtx.getComputationNodeDomain().cardinality().intValue();
    }

    public double getMaxMemorySizeForJoin() {
        return this.physOptConfig.getMaxFramesForJoin() * this.physOptConfig.getFrameSize();
    }

    public double getMaxMemorySizeForGroup() {
        return this.physOptConfig.getMaxFramesForGroupBy() * this.physOptConfig.getFrameSize();
    }

    public double getMaxMemorySizeForSort() {
        return this.physOptConfig.getMaxFramesExternalSort() * this.physOptConfig.getFrameSize();
    }

    @Override
    public Cost costFullScan(JoinNode jn) {
        return new Cost(jn.getOrigCardinality());
    }

    @Override
    public Cost costIndexScan(JoinNode jn, double indexSel) {
        return new Cost(indexSel * jn.getOrigCardinality());
    }

    public Cost costIndexDataScan(JoinNode jn, double indexSel) {
        if (indexSel < selectivityForSecondaryIndexSelection) {
            return new Cost(indexSel * jn.getOrigCardinality());
        }
        return new Cost(jn.getOrigCardinality());
    }

    @Override
    public Cost costHashJoin(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        JoinNode rightJn = jn.getRightJn();
        return new Cost(leftJn.getCardinality() + rightJn.getCardinality());
    }

    public Cost computeHJProbeExchangeCost(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        return new Cost(leftJn.getCardinality());
    }

    public Cost computeHJBuildExchangeCost(JoinNode jn) {
        JoinNode rightJn = jn.getRightJn();
        return new Cost(rightJn.getCardinality());
    }

    @Override
    public Cost costBroadcastHashJoin(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        JoinNode rightJn = jn.getRightJn();
        return new Cost(leftJn.getCardinality() + (double)this.DOP * rightJn.getCardinality());
    }

    public Cost computeBHJBuildExchangeCost(JoinNode jn) {
        JoinNode rightJn = jn.getRightJn();
        return new Cost((double)this.DOP * rightJn.getCardinality());
    }

    @Override
    public Cost costIndexNLJoin(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        JoinNode rightJn = jn.getRightJn();
        double origRightCard = rightJn.getOrigCardinality();
        double innerCard = rightJn.getCardinality();
        double joinCard = jn.getCardinality();
        return new Cost(4.0 * leftJn.getCardinality() + joinCard * origRightCard / innerCard);
    }

    public Cost computeNLJOuterExchangeCost(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        return new Cost((double)this.DOP * leftJn.getCardinality());
    }

    @Override
    public Cost costCartesianProductJoin(JoinNode jn) {
        JoinNode leftJn = jn.getLeftJn();
        JoinNode rightJn = jn.getRightJn();
        return new Cost(leftJn.getCardinality() * rightJn.getCardinality());
    }

    public Cost computeCPRightExchangeCost(JoinNode jn) {
        JoinNode rightJn = jn.getRightJn();
        return new Cost((double)this.DOP * rightJn.getCardinality());
    }

    @Override
    public Cost costHashGroupBy(GroupByOperator groupByOperator) {
        Pair<Double, Double> cards = this.getOpCards((ILogicalOperator)groupByOperator);
        double inputCard = (Double)cards.getFirst();
        return new Cost(inputCard);
    }

    @Override
    public Cost costSortGroupBy(GroupByOperator groupByOperator) {
        Pair<Double, Double> cards = this.getOpCards((ILogicalOperator)groupByOperator);
        double inputCard = (Double)cards.getFirst();
        return new Cost(this.costSort(inputCard));
    }

    @Override
    public Cost costDistinct(DistinctOperator distinctOperator) {
        Pair<Double, Double> cards = this.getOpCards((ILogicalOperator)distinctOperator);
        double inputCard = (Double)cards.getFirst();
        return new Cost(this.costSort(inputCard));
    }

    @Override
    public Cost costOrderBy(OrderOperator orderOp) {
        Pair<Double, Double> cards = this.getOpCards((ILogicalOperator)orderOp);
        double inputCard = (Double)cards.getFirst();
        return new Cost(this.costSort(inputCard));
    }

    protected Pair<Double, Double> getOpCards(ILogicalOperator op) {
        Pair cardCost = new Pair((Object)0.0, (Object)0.0);
        for (Map.Entry anno : op.getAnnotations().entrySet()) {
            if (anno.getValue() != null && ((String)anno.getKey()).equals("INPUT_CARDINALITY")) {
                cardCost.setFirst((Object)((Double)anno.getValue()));
                continue;
            }
            if (anno.getValue() == null || !((String)anno.getKey()).equals("OUTPUT_CARDINALITY")) continue;
            cardCost.setSecond((Object)((Double)anno.getValue()));
        }
        return cardCost;
    }

    protected double costSort(double inputCard) {
        return inputCard <= 1.0 ? 0.0 : inputCard * Math.log(inputCard) / Math.log(2.0);
    }
}

