/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.IntegerLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.optype.SetOpType;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public final class SqlCompatRewriteVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    private final LangRewritingContext context;
    private final SelectExpressionAnalyzer selectExprAnalyzer = new SelectExpressionAnalyzer();

    public SqlCompatRewriteVisitor(LangRewritingContext context) {
        this.context = context;
    }

    @Override
    public Expression visit(Projection projection, ILangExpression arg) throws CompilationException {
        if (projection.getKind() == Projection.Kind.STAR) {
            projection.setKind(Projection.Kind.EVERY_VAR_STAR);
        }
        return super.visit(projection, arg);
    }

    @Override
    public Expression visit(FromTerm fromTerm, ILangExpression arg) throws CompilationException {
        Expression expr = fromTerm.getLeftExpression();
        if (expr.getKind() == Expression.Kind.SELECT_EXPRESSION) {
            this.annotateSubqueryNoCoercion((SelectExpression)expr);
        }
        return super.visit(fromTerm, arg);
    }

    @Override
    public Expression visit(JoinClause joinClause, ILangExpression arg) throws CompilationException {
        Expression expr = joinClause.getRightExpression();
        if (expr.getKind() == Expression.Kind.SELECT_EXPRESSION) {
            this.annotateSubqueryNoCoercion((SelectExpression)expr);
        }
        switch (joinClause.getJoinType()) {
            case LEFTOUTER: 
            case RIGHTOUTER: {
                joinClause.setOuterJoinMissingValueType(Literal.Type.NULL);
                break;
            }
            case INNER: {
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, joinClause.getSourceLocation(), new Serializable[]{String.valueOf((Object)joinClause.getJoinType())});
            }
        }
        return super.visit(joinClause, arg);
    }

    @Override
    public Expression visit(UnnestClause unnestClause, ILangExpression arg) throws CompilationException {
        Expression expr = unnestClause.getRightExpression();
        if (expr.getKind() == Expression.Kind.SELECT_EXPRESSION) {
            this.annotateSubqueryNoCoercion((SelectExpression)expr);
        }
        switch (unnestClause.getUnnestType()) {
            case LEFTOUTER: {
                unnestClause.setOuterUnnestMissingValueType(Literal.Type.NULL);
                break;
            }
            case INNER: {
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, unnestClause.getSourceLocation(), new Serializable[]{String.valueOf((Object)unnestClause.getUnnestType())});
            }
        }
        return super.visit(unnestClause, arg);
    }

    @Override
    public Expression visit(LetClause letClause, ILangExpression arg) throws CompilationException {
        Expression expr = letClause.getBindingExpr();
        if (expr.getKind() == Expression.Kind.SELECT_EXPRESSION) {
            this.annotateSubqueryNoCoercion((SelectExpression)expr);
        }
        return super.visit(letClause, arg);
    }

    @Override
    public Expression visit(QuantifiedExpression qe, ILangExpression arg) throws CompilationException {
        for (QuantifiedPair pair : qe.getQuantifiedList()) {
            Expression expr = pair.getExpr();
            if (expr.getKind() != Expression.Kind.SELECT_EXPRESSION) continue;
            this.annotateSubqueryNoCoercion((SelectExpression)expr);
        }
        return super.visit(qe, arg);
    }

    @Override
    public Expression visit(OperatorExpr opExpr, ILangExpression arg) throws CompilationException {
        List opTypeList = opExpr.getOpList();
        if (opTypeList.size() == 1) {
            OperatorType opType = (OperatorType)opTypeList.get(0);
            if (OperatorExpr.opIsComparison((OperatorType)opType)) {
                List argList = opExpr.getExprList();
                Expression lhs = (Expression)argList.get(0);
                Expression rhs = (Expression)argList.get(1);
                if (lhs.getKind() == Expression.Kind.SELECT_EXPRESSION) {
                    this.annotateComparisonOpSubquery((SelectExpression)lhs, rhs);
                }
                if (rhs.getKind() == Expression.Kind.SELECT_EXPRESSION) {
                    this.annotateComparisonOpSubquery((SelectExpression)rhs, lhs);
                }
            } else if (opType == OperatorType.IN || opType == OperatorType.NOT_IN) {
                List argList = opExpr.getExprList();
                Expression lhs = (Expression)argList.get(0);
                Expression rhs = (Expression)argList.get(1);
                switch (rhs.getKind()) {
                    case SELECT_EXPRESSION: {
                        this.annotateInOpSubquery((SelectExpression)rhs, lhs);
                        break;
                    }
                    case LIST_CONSTRUCTOR_EXPRESSION: 
                    case LIST_SLICE_EXPRESSION: {
                        break;
                    }
                    default: {
                        ArrayList<Object> newExprList = new ArrayList<Object>(2);
                        newExprList.add(lhs);
                        newExprList.add(SqlCompatRewriteVisitor.createCallExpr(BuiltinFunctions.TO_ARRAY, rhs, opExpr.getSourceLocation()));
                        opExpr.setExprList(newExprList);
                    }
                }
            }
        }
        return super.visit(opExpr, arg);
    }

    @Override
    public Expression visit(UnaryExpr u, ILangExpression arg) throws CompilationException {
        switch (u.getExprType()) {
            case EXISTS: 
            case NOT_EXISTS: {
                Expression expr = u.getExpr();
                if (expr.getKind() != Expression.Kind.SELECT_EXPRESSION) break;
                this.annotateSubqueryNoCoercion((SelectExpression)expr);
            }
        }
        return super.visit(u, arg);
    }

    @Override
    public Expression visit(SelectExpression selectExpr, ILangExpression arg) throws CompilationException {
        SqlCompatSelectExpressionCoercionAnnotation selectExprAnn = null;
        if (selectExpr.isSubquery() && (selectExprAnn = (SqlCompatSelectExpressionCoercionAnnotation)selectExpr.findHint(SqlCompatSelectExpressionCoercionAnnotation.class)) == null) {
            selectExprAnn = this.annotateSubquery(selectExpr, SqlCompatSelectCoercionKind.SCALAR, SqlCompatSelectCoercionKind.SCALAR);
        }
        Expression newExpr = super.visit(selectExpr, arg);
        if (selectExprAnn != null) {
            newExpr = this.rewriteSelectExpression(newExpr, selectExprAnn);
        }
        return newExpr;
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        super.visit(selectBlock, arg);
        SelectExpression selectExpr = (SelectExpression)arg;
        SqlCompatSelectExpressionCoercionAnnotation selectExprAnn = (SqlCompatSelectExpressionCoercionAnnotation)selectExpr.findHint(SqlCompatSelectExpressionCoercionAnnotation.class);
        if (selectExprAnn != null) {
            this.rewriteSelectBlock(selectBlock, selectExprAnn);
        }
        return null;
    }

    private void annotateSubqueryNoCoercion(SelectExpression subqueryExpr) {
        subqueryExpr.addHint(SqlCompatSelectExpressionCoercionAnnotation.NONE_NONE);
    }

    private void annotateComparisonOpSubquery(SelectExpression subqueryExpr, Expression otherArg) throws CompilationException {
        this.annotateSubquery(subqueryExpr, SqlCompatSelectCoercionKind.SCALAR, SqlCompatRewriteVisitor.getSelectBlockAnnotationForOpSubquery(otherArg));
    }

    private void annotateInOpSubquery(SelectExpression subqueryExpr, Expression otherArg) throws CompilationException {
        this.annotateSubquery(subqueryExpr, SqlCompatSelectCoercionKind.NONE, SqlCompatRewriteVisitor.getSelectBlockAnnotationForOpSubquery(otherArg));
    }

    private static SqlCompatSelectCoercionKind getSelectBlockAnnotationForOpSubquery(Expression otherArg) throws CompilationException {
        if (otherArg.getKind() == Expression.Kind.LIST_CONSTRUCTOR_EXPRESSION) {
            ListConstructor lc = (ListConstructor)otherArg;
            switch (lc.getType()) {
                case ORDERED_LIST_CONSTRUCTOR: {
                    return SqlCompatSelectCoercionKind.ARRAY;
                }
                case UNORDERED_LIST_CONSTRUCTOR: {
                    return SqlCompatSelectCoercionKind.MULTISET;
                }
            }
            throw new CompilationException(ErrorCode.ILLEGAL_STATE, otherArg.getSourceLocation(), new Serializable[]{""});
        }
        return SqlCompatSelectCoercionKind.SCALAR;
    }

    private SqlCompatSelectExpressionCoercionAnnotation annotateSubquery(SelectExpression subqueryExpr, SqlCompatSelectCoercionKind cardinalityCoercion, SqlCompatSelectCoercionKind typeCoercion) throws CompilationException {
        this.selectExprAnalyzer.analyze(subqueryExpr.getSelectSetOperation(), true);
        if (this.selectExprAnalyzer.subqueryExists) {
            throw new CompilationException(ErrorCode.COMPILATION_SUBQUERY_COERCION_ERROR, subqueryExpr.getSourceLocation(), new Serializable[]{""});
        }
        if (this.selectExprAnalyzer.selectRegularExists) {
            if (this.selectExprAnalyzer.selectElementExists) {
                throw new CompilationException(ErrorCode.COMPILATION_SUBQUERY_COERCION_ERROR, subqueryExpr.getSourceLocation(), new Serializable[]{"Both SELECT and SELECT VALUE are present"});
            }
            String typeCoercionFieldName = typeCoercion == SqlCompatSelectCoercionKind.NONE ? null : this.selectExprAnalyzer.generateFieldName(this.context);
            SqlCompatSelectExpressionCoercionAnnotation ann = new SqlCompatSelectExpressionCoercionAnnotation(cardinalityCoercion, typeCoercion, typeCoercionFieldName);
            subqueryExpr.addHint(ann);
            return ann;
        }
        return null;
    }

    @Override
    public Expression visit(SelectSetOperation setOp, ILangExpression arg) throws CompilationException {
        super.visit(setOp, arg);
        if (setOp.hasRightInputs()) {
            this.selectExprAnalyzer.analyze(setOp, false);
            if (this.selectExprAnalyzer.subqueryExists) {
                throw new CompilationException(ErrorCode.COMPILATION_SET_OPERATION_ERROR, setOp.getSourceLocation(), new Serializable[]{setOp.getRightInputs().get(0).getSetOpType().toString(), ""});
            }
            if (this.selectExprAnalyzer.selectRegularExists) {
                if (this.selectExprAnalyzer.selectElementExists) {
                    throw new CompilationException(ErrorCode.COMPILATION_SET_OPERATION_ERROR, setOp.getSourceLocation(), new Serializable[]{setOp.getRightInputs().get(0).getSetOpType().toString(), "Both SELECT and SELECT VALUE are present"});
                }
                this.rewriteSelectSetOp(setOp);
            }
        }
        return null;
    }

    private void rewriteSelectSetOp(SelectSetOperation setOp) throws CompilationException {
        boolean ok;
        SelectBlock leftSelectBlock = setOp.getLeftInput().getSelectBlock();
        boolean bl = ok = leftSelectBlock != null && setOp.hasRightInputs();
        if (!ok) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, setOp.getSourceLocation(), new Serializable[]{""});
        }
        List<String> leftFieldNames = this.collectFieldNames(leftSelectBlock, setOp.getRightInputs().get(0).getSetOpType());
        for (SetOperationRight rightInput : setOp.getRightInputs()) {
            this.rewriteSelectSetOpRightInput(rightInput, leftFieldNames, setOp.getSourceLocation());
        }
    }

    private void rewriteSelectSetOpRightInput(SetOperationRight setOpRight, List<String> outputFieldNames, SourceLocation sourceLoc) throws CompilationException {
        SetOperationInput setOpRightInput = setOpRight.getSetOperationRightInput();
        SelectBlock rightSelectBlock = setOpRightInput.getSelectBlock();
        if (rightSelectBlock == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, sourceLoc, new Serializable[]{""});
        }
        List<String> inputFieldNames = this.collectFieldNames(rightSelectBlock, setOpRight.getSetOpType());
        int nFields = inputFieldNames.size();
        if (nFields != outputFieldNames.size()) {
            throw new CompilationException(ErrorCode.COMPILATION_SET_OPERATION_ERROR, sourceLoc, new Serializable[]{setOpRight.getSetOpType().toString(), "Unequal number of input fields"});
        }
        SelectSetOperation setOp1 = new SelectSetOperation(new SetOperationInput(rightSelectBlock, null), null);
        setOp1.setSourceLocation(sourceLoc);
        SelectExpression selectExpr1 = new SelectExpression(null, setOp1, null, null, true);
        selectExpr1.setSourceLocation(sourceLoc);
        VarIdentifier v1 = this.context.newVariable();
        VariableExpr v1Expr1 = new VariableExpr(v1);
        v1Expr1.setSourceLocation(sourceLoc);
        FromTerm fromTerm1 = new FromTerm((Expression)selectExpr1, v1Expr1, null, null);
        fromTerm1.setSourceLocation(sourceLoc);
        ArrayList<FromTerm> fromTermList1 = new ArrayList<FromTerm>(1);
        fromTermList1.add(fromTerm1);
        FromClause fromClause1 = new FromClause(fromTermList1);
        fromClause1.setSourceLocation(sourceLoc);
        ArrayList<FieldBinding> fb1List = new ArrayList<FieldBinding>(nFields);
        for (int i = 0; i < nFields; ++i) {
            VariableExpr v1Expr2 = new VariableExpr(v1);
            v1Expr2.setSourceLocation(sourceLoc);
            FieldAccessor fa1 = new FieldAccessor((Expression)v1Expr2, new Identifier(inputFieldNames.get(i)));
            fa1.setSourceLocation(sourceLoc);
            LiteralExpr lit1 = new LiteralExpr((Literal)new StringLiteral(outputFieldNames.get(i)));
            lit1.setSourceLocation(sourceLoc);
            fb1List.add(new FieldBinding((Expression)lit1, (Expression)fa1));
        }
        RecordConstructor rc1 = new RecordConstructor(fb1List);
        rc1.setSourceLocation(sourceLoc);
        SelectClause selectClause1 = new SelectClause(new SelectElement((Expression)rc1), null, false);
        selectClause1.setSourceLocation(sourceLoc);
        SelectBlock newRightSelectBlock = new SelectBlock(selectClause1, fromClause1, null, null, null);
        newRightSelectBlock.setSourceLocation(sourceLoc);
        setOpRightInput.setSelectBlock(newRightSelectBlock);
    }

    private List<String> collectFieldNames(SelectBlock selectBlock, SetOpType setOpType) throws CompilationException {
        SelectRegular selectRegular = selectBlock.getSelectClause().getSelectRegular();
        if (selectRegular == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, selectBlock.getSourceLocation(), new Serializable[]{""});
        }
        List<Projection> projectionList = selectRegular.getProjections();
        ArrayList<String> fieldNames = new ArrayList<String>(projectionList.size());
        for (Projection projection : projectionList) {
            if (projection.getKind() != Projection.Kind.NAMED_EXPR) {
                throw new CompilationException(ErrorCode.COMPILATION_SET_OPERATION_ERROR, projection.getSourceLocation(), new Serializable[]{setOpType.toString(), "Unsupported projection kind"});
            }
            fieldNames.add(projection.getName());
        }
        return fieldNames;
    }

    private static CallExpr createCallExpr(FunctionIdentifier fid, Expression inExpr, SourceLocation sourceLoc) {
        ArrayList<Expression> argList = new ArrayList<Expression>(1);
        argList.add(inExpr);
        CallExpr callExpr = new CallExpr(new FunctionSignature(fid), argList);
        callExpr.setSourceLocation(sourceLoc);
        return callExpr;
    }

    private void rewriteSelectBlock(SelectBlock selectBlock, SqlCompatSelectExpressionCoercionAnnotation ann) throws CompilationException {
        SqlCompatSelectCoercionKind typeCoercion = ann.typeCoercion;
        switch (typeCoercion) {
            case SCALAR: {
                SelectClause selectClause = selectBlock.getSelectClause();
                List<Projection> projectList = selectClause.getSelectRegular().getProjections();
                if (projectList.size() > 1) {
                    throw new CompilationException(ErrorCode.COMPILATION_SUBQUERY_COERCION_ERROR, projectList.get(1).getSourceLocation(), new Serializable[]{"Subquery returns more than one field"});
                }
                Projection projection = projectList.get(0);
                if (projection.getKind() != Projection.Kind.NAMED_EXPR) {
                    throw new CompilationException(ErrorCode.COMPILATION_SUBQUERY_COERCION_ERROR, projection.getSourceLocation(), new Serializable[]{"Unsupported projection kind"});
                }
                Projection typeCoercionProj = new Projection(Projection.Kind.NAMED_EXPR, (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)projection.getExpression()), ann.typeCoercionFieldName);
                projectList.add(typeCoercionProj);
                break;
            }
            case ARRAY: 
            case MULTISET: {
                SelectClause selectClause = selectBlock.getSelectClause();
                List<Projection> projectList = selectClause.getSelectRegular().getProjections();
                ArrayList<Expression> exprList = new ArrayList<Expression>(projectList.size());
                for (Projection p : projectList) {
                    if (p.getKind() != Projection.Kind.NAMED_EXPR) {
                        throw new CompilationException(ErrorCode.COMPILATION_SUBQUERY_COERCION_ERROR, p.getSourceLocation(), new Serializable[]{"Unsupported projection kind"});
                    }
                    exprList.add((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)p.getExpression()));
                }
                ListConstructor.Type listType = typeCoercion == SqlCompatSelectCoercionKind.ARRAY ? ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR : ListConstructor.Type.UNORDERED_LIST_CONSTRUCTOR;
                ListConstructor listExpr = new ListConstructor(listType, exprList);
                listExpr.setSourceLocation(selectClause.getSourceLocation());
                Projection typeCoercionProj = new Projection(Projection.Kind.NAMED_EXPR, (Expression)listExpr, ann.typeCoercionFieldName);
                projectList.add(typeCoercionProj);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.ILLEGAL_STATE, selectBlock.getSourceLocation(), new Serializable[]{ann.toString()});
            }
        }
    }

    private Expression rewriteSelectExpression(Expression inExpr, SqlCompatSelectExpressionCoercionAnnotation ann) throws CompilationException {
        SelectSetOperation sop1;
        SelectBlock sb1;
        SelectClause sc1;
        SelectElement sv1;
        SourceLocation sourceLoc = inExpr.getSourceLocation();
        if (ann.typeCoercion != SqlCompatSelectCoercionKind.NONE) {
            VarIdentifier v1 = this.context.newVariable();
            VariableExpr v1Ref1 = new VariableExpr(v1);
            v1Ref1.setSourceLocation(sourceLoc);
            FromTerm ft1 = new FromTerm((Expression)inExpr, v1Ref1, null, null);
            ft1.setSourceLocation(sourceLoc);
            ArrayList<FromTerm> fc1Terms = new ArrayList<FromTerm>(1);
            fc1Terms.add(ft1);
            FromClause fc1 = new FromClause(fc1Terms);
            fc1.setSourceLocation(sourceLoc);
            VariableExpr v1Ref2 = new VariableExpr(v1);
            v1Ref2.setSourceLocation(sourceLoc);
            FieldAccessor fa = new FieldAccessor((Expression)v1Ref2, new Identifier(ann.typeCoercionFieldName));
            fa.setSourceLocation(sourceLoc);
            sv1 = new SelectElement((Expression)fa);
            sv1.setSourceLocation(sourceLoc);
            sc1 = new SelectClause(sv1, null, false);
            sc1.setSourceLocation(sourceLoc);
            sb1 = new SelectBlock(sc1, fc1, null, null, null);
            sv1.setSourceLocation(sourceLoc);
            sop1 = new SelectSetOperation(new SetOperationInput(sb1, null), null);
            sop1.setSourceLocation(sourceLoc);
            SelectExpression se1 = new SelectExpression(null, sop1, null, null, true);
            se1.setSourceLocation(sourceLoc);
            inExpr = se1;
        }
        SqlCompatSelectCoercionKind cardinalityCoercion = ann.cardinalityCoercion;
        switch (cardinalityCoercion) {
            case SCALAR: {
                VarIdentifier v1 = this.context.newVariable();
                VariableExpr v1Ref1 = new VariableExpr(v1);
                v1Ref1.setSourceLocation(sourceLoc);
                FromTerm ft1 = new FromTerm((Expression)inExpr, v1Ref1, null, null);
                ft1.setSourceLocation(sourceLoc);
                ArrayList<FromTerm> fc1Terms = new ArrayList<FromTerm>(1);
                fc1Terms.add(ft1);
                FromClause fc1 = new FromClause(fc1Terms);
                fc1.setSourceLocation(sourceLoc);
                VariableExpr v1Ref2 = new VariableExpr(v1);
                v1Ref2.setSourceLocation(sourceLoc);
                sv1 = new SelectElement((Expression)v1Ref2);
                sv1.setSourceLocation(sourceLoc);
                sc1 = new SelectClause(sv1, null, false);
                sc1.setSourceLocation(sourceLoc);
                sb1 = new SelectBlock(sc1, fc1, null, null, null);
                sv1.setSourceLocation(sourceLoc);
                sop1 = new SelectSetOperation(new SetOperationInput(sb1, null), null);
                sop1.setSourceLocation(sourceLoc);
                LimitClause lc1 = new LimitClause((Expression)new LiteralExpr((Literal)new IntegerLiteral(Integer.valueOf(2))), null);
                lc1.setSourceLocation(sourceLoc);
                SelectExpression se1 = new SelectExpression(null, sop1, null, lc1, true);
                se1.setSourceLocation(sourceLoc);
                VarIdentifier v2 = this.context.newVariable();
                VariableExpr v2Ref1 = new VariableExpr(v2);
                v2Ref1.setSourceLocation(sourceLoc);
                LetClause lc2 = new LetClause(v2Ref1, (Expression)se1);
                lc2.setSourceLocation(sourceLoc);
                VariableExpr v2Ref2 = new VariableExpr(v2);
                v2Ref2.setSourceLocation(sourceLoc);
                ArrayList<VariableExpr> lenArgs = new ArrayList<VariableExpr>(1);
                lenArgs.add(v2Ref2);
                CallExpr lenExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.LEN), lenArgs);
                lenExpr.setSourceLocation(sourceLoc);
                OperatorExpr minusExpr = new OperatorExpr();
                minusExpr.setCurrentop(true);
                minusExpr.addOperator(OperatorType.MINUS);
                minusExpr.addOperand((Expression)lenExpr);
                minusExpr.addOperand((Expression)new LiteralExpr((Literal)new IntegerLiteral(Integer.valueOf(1))));
                minusExpr.setSourceLocation(sourceLoc);
                OperatorExpr mulExpr = new OperatorExpr();
                mulExpr.setCurrentop(true);
                mulExpr.addOperator(OperatorType.MUL);
                mulExpr.addOperand((Expression)minusExpr);
                mulExpr.addOperand((Expression)new LiteralExpr((Literal)new IntegerLiteral(Integer.valueOf(2))));
                mulExpr.setSourceLocation(sourceLoc);
                VariableExpr v2Ref3 = new VariableExpr(v2);
                v2Ref3.setSourceLocation(sourceLoc);
                IndexAccessor iaExpr = new IndexAccessor((Expression)v2Ref3, IndexAccessor.IndexKind.ELEMENT, (Expression)mulExpr);
                iaExpr.setSourceLocation(sourceLoc);
                SelectElement sv2 = new SelectElement((Expression)iaExpr);
                sv2.setSourceLocation(sourceLoc);
                SelectClause sc2 = new SelectClause(sv2, null, false);
                sc2.setSourceLocation(sourceLoc);
                ArrayList<AbstractClause> sb2Clauses = new ArrayList<AbstractClause>(1);
                sb2Clauses.add((AbstractClause)lc2);
                SelectBlock sb2 = new SelectBlock(sc2, null, sb2Clauses, null, null);
                sb2.setSourceLocation(sourceLoc);
                SelectSetOperation sop2 = new SelectSetOperation(new SetOperationInput(sb2, null), null);
                sop2.setSourceLocation(sourceLoc);
                SelectExpression se2 = new SelectExpression(null, sop2, null, null, true);
                se2.setSourceLocation(sourceLoc);
                ArrayList<SelectExpression> firstElemArgs = new ArrayList<SelectExpression>(1);
                firstElemArgs.add(se2);
                FunctionIdentifier firstElemFun = FunctionMapUtil.createCoreAggregateFunctionIdentifier(BuiltinFunctions.SCALAR_FIRST_ELEMENT);
                CallExpr firstElemExpr = new CallExpr(new FunctionSignature(firstElemFun), firstElemArgs);
                firstElemExpr.setSourceLocation(sourceLoc);
                return firstElemExpr;
            }
            case NONE: {
                return inExpr;
            }
        }
        throw new CompilationException(ErrorCode.ILLEGAL_STATE, inExpr.getSourceLocation(), new Serializable[]{ann.toString()});
    }

    private static final class SelectExpressionAnalyzer {
        private boolean subqueryExists;
        private boolean selectRegularExists;
        private boolean selectElementExists;
        private boolean computeSelectRegularAllFields;
        private final Set<String> selectRegularAllFields = new HashSet<String>();

        private SelectExpressionAnalyzer() {
        }

        private void reset(boolean computeSelectRegularAllFields) {
            this.subqueryExists = false;
            this.selectRegularExists = false;
            this.selectElementExists = false;
            this.selectRegularAllFields.clear();
            this.computeSelectRegularAllFields = computeSelectRegularAllFields;
        }

        private void analyze(SelectSetOperation setOp, boolean computeSelectRegularAllFields) throws CompilationException {
            this.reset(computeSelectRegularAllFields);
            this.analyzeSelectSetOpInput(setOp.getLeftInput());
            if (setOp.hasRightInputs()) {
                for (SetOperationRight rhs : setOp.getRightInputs()) {
                    this.analyzeSelectSetOpInput(rhs.getSetOperationRightInput());
                }
            }
        }

        private void analyzeSelectSetOpInput(SetOperationInput setOpInput) throws CompilationException {
            if (setOpInput.selectBlock()) {
                SelectBlock selectBlock = setOpInput.getSelectBlock();
                SelectClause selectClause = selectBlock.getSelectClause();
                if (selectClause.selectRegular()) {
                    this.selectRegularExists = true;
                    if (this.computeSelectRegularAllFields) {
                        for (Projection projection : selectClause.getSelectRegular().getProjections()) {
                            if (projection.getKind() != Projection.Kind.NAMED_EXPR) continue;
                            this.selectRegularAllFields.add(projection.getName());
                        }
                    }
                } else if (selectClause.selectElement()) {
                    this.selectElementExists = true;
                }
            } else if (setOpInput.subquery()) {
                this.subqueryExists = true;
            } else {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{""});
            }
        }

        private String generateFieldName(LangRewritingContext ctx) {
            String fieldName;
            while (this.selectRegularAllFields.contains(fieldName = SqlppVariableUtil.variableNameToDisplayedFieldName(ctx.newVariable().getValue()))) {
            }
            return fieldName;
        }
    }

    private static class SqlCompatSelectExpressionCoercionAnnotation
    implements IExpressionAnnotation {
        static final SqlCompatSelectExpressionCoercionAnnotation NONE_NONE = new SqlCompatSelectExpressionCoercionAnnotation(SqlCompatSelectCoercionKind.NONE, SqlCompatSelectCoercionKind.NONE, null);
        final SqlCompatSelectCoercionKind cardinalityCoercion;
        final SqlCompatSelectCoercionKind typeCoercion;
        final String typeCoercionFieldName;

        SqlCompatSelectExpressionCoercionAnnotation(SqlCompatSelectCoercionKind cardinalityCoercion, SqlCompatSelectCoercionKind typeCoercion, String typeCoercionFieldName) {
            this.cardinalityCoercion = Objects.requireNonNull(cardinalityCoercion);
            this.typeCoercion = Objects.requireNonNull(typeCoercion);
            this.typeCoercionFieldName = typeCoercionFieldName;
        }
    }

    private static enum SqlCompatSelectCoercionKind {
        NONE,
        SCALAR,
        ARRAY,
        MULTISET;

    }
}

