/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class AUnorderedListType
extends AbstractCollectionType {
    private static final long serialVersionUID = 1L;
    public static final AUnorderedListType FULLY_OPEN_UNORDEREDLIST_TYPE = new AUnorderedListType(BuiltinType.ANY, "");

    public AUnorderedListType(IAType itemType, String typeName) {
        super(itemType, typeName);
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.MULTISET;
    }

    @Override
    public String getDisplayName() {
        return "multiset";
    }

    public String toString() {
        return "{{ " + this.getItemType() + " }}";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AUnorderedListType) {
            AUnorderedListType type = (AUnorderedListType)obj;
            return this.getItemType().equals(type.getItemType());
        }
        return false;
    }

    public int hashCode() {
        return this.getItemType().hashCode() * 10;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode type = om.createObjectNode();
        type.put("type", AUnorderedListType.class.getName());
        type.set("item-type", (JsonNode)this.getItemType().toJSON());
        return type;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        return this.convertToJson(registry, this.getClass(), 1L);
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        return AUnorderedListType.convertToObject(registry, json, false);
    }
}

