/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.lazy;

import java.util.Objects;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.lazy.AbstractLazyVisitablePointable;
import org.apache.asterix.om.lazy.MissingLazyVisitablePointable;
import org.apache.asterix.om.lazy.NullLazyVisitablePointable;
import org.apache.asterix.om.lazy.RecordLazyVisitablePointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class TypedRecordLazyVisitablePointable
extends RecordLazyVisitablePointable {
    private static final IPointable MISSING_POINTABLE = TypedRecordLazyVisitablePointable.createConstantPointable(ATypeTag.MISSING);
    private static final IPointable NULL_POINTABLE = TypedRecordLazyVisitablePointable.createConstantPointable(ATypeTag.NULL);
    private final ARecordType recordType;
    private final IValueReference[] closedFieldNames;
    private final AbstractLazyVisitablePointable[] closedVisitables;
    private final int numberOfClosedChildren;
    private final ATypeTag[] closedChildTags;
    private final int actualChildOffset;
    private int currentIndex;
    private int closedValuesOffset;

    public TypedRecordLazyVisitablePointable(ARecordType rootRecordType) {
        this(true, rootRecordType);
    }

    public TypedRecordLazyVisitablePointable(boolean tagged, ARecordType recordType) {
        super(tagged);
        Objects.requireNonNull(recordType);
        this.recordType = recordType;
        this.numberOfClosedChildren = this.recordType.getFieldTypes().length;
        this.closedFieldNames = TypedRecordLazyVisitablePointable.createSerializedClosedFieldNames(this.recordType);
        this.closedVisitables = TypedRecordLazyVisitablePointable.createClosedVisitables(this.recordType);
        this.closedChildTags = TypedRecordLazyVisitablePointable.createInitialClosedTypeTags(this.recordType);
        this.actualChildOffset = this.isTagged() ? 0 : -1;
    }

    @Override
    public void nextChild() throws HyracksDataException {
        ++this.currentIndex;
        if (this.isTaggedChild()) {
            super.nextChild();
        } else {
            this.setClosedValueInfo();
        }
    }

    @Override
    public boolean isTaggedChild() {
        return this.currentIndex >= this.numberOfClosedChildren;
    }

    @Override
    public int getNumberOfChildren() {
        return this.numberOfClosedChildren + super.getNumberOfChildren();
    }

    @Override
    public AbstractLazyVisitablePointable getChildVisitablePointable() throws HyracksDataException {
        AbstractLazyVisitablePointable visitablePointable = this.isTaggedChild() ? this.openVisitable : this.getClosedChildVisitable();
        visitablePointable.set(this.getChildValue());
        return visitablePointable;
    }

    private AbstractLazyVisitablePointable getClosedChildVisitable() {
        switch (this.getChildTypeTag()) {
            case MISSING: {
                return MissingLazyVisitablePointable.INSTANCE;
            }
            case NULL: {
                return NullLazyVisitablePointable.INSTANCE;
            }
        }
        return this.closedVisitables[this.currentIndex];
    }

    private void setClosedValueInfo() throws HyracksDataException {
        ATypeTag typeTag = this.closedChildTags[this.currentIndex];
        if (typeTag == ATypeTag.NULL) {
            this.currentValue.set((IValueReference)NULL_POINTABLE);
        } else if (typeTag == ATypeTag.MISSING) {
            this.currentValue.set((IValueReference)MISSING_POINTABLE);
        } else {
            byte[] data = this.getByteArray();
            int offset = this.getStartOffset() + AInt32SerializerDeserializer.getInt(data, this.closedValuesOffset + 4 * this.currentIndex) + this.actualChildOffset;
            int length = NonTaggedFormatUtil.getFieldValueLength(data, offset, typeTag, false);
            this.currentValue.set(data, offset, length);
        }
        this.currentFieldName.set(this.closedFieldNames[this.currentIndex]);
        this.currentChildTypeTag = typeTag.serialize();
    }

    @Override
    void init(byte[] data, int offset, int length) {
        int skipTag = this.isTagged() ? 1 : 0;
        this.currentIndex = -1;
        int pointer = this.recordType.isOpen() ? this.initOpenPart(data, offset) : offset + skipTag + 4;
        this.initClosedPart(pointer, data);
    }

    private void initClosedPart(int pointer, byte[] data) {
        int currentPointer = pointer + 4;
        if (NonTaggedFormatUtil.hasOptionalField(this.recordType)) {
            this.initClosedChildrenTags(data, currentPointer);
            currentPointer += this.numberOfClosedChildren % 4 == 0 ? this.numberOfClosedChildren / 4 : this.numberOfClosedChildren / 4 + 1;
        }
        this.closedValuesOffset = currentPointer;
    }

    private static IPointable createConstantPointable(ATypeTag tag) {
        byte[] data = new byte[]{tag.serialize()};
        VoidPointable value = new VoidPointable();
        value.set(data, 0, 1);
        return value;
    }

    private void initClosedChildrenTags(byte[] data, int nullBitMapOffset) {
        IAType[] types = this.recordType.getFieldTypes();
        for (int i = 0; i < this.numberOfClosedChildren; ++i) {
            byte nullMissingOrValue = data[nullBitMapOffset + i / 4];
            if (RecordUtil.isNull(nullMissingOrValue, i)) {
                this.closedChildTags[i] = ATypeTag.NULL;
                continue;
            }
            if (RecordUtil.isMissing(nullMissingOrValue, i)) {
                this.closedChildTags[i] = ATypeTag.MISSING;
                continue;
            }
            IAType type = types[i];
            type = type.getTypeTag() == ATypeTag.UNION ? ((AUnionType)type).getActualType() : type;
            this.closedChildTags[i] = type.getTypeTag();
        }
    }

    private static ATypeTag[] createInitialClosedTypeTags(ARecordType recordType) {
        IAType[] types = recordType.getFieldTypes();
        ATypeTag[] typeTags = new ATypeTag[types.length];
        for (int i = 0; i < types.length; ++i) {
            IAType type = types[i];
            if (type.getTypeTag() == ATypeTag.UNION) {
                type = ((AUnionType)type).getActualType();
            }
            typeTags[i] = type.getTypeTag();
        }
        return typeTags;
    }

    private static IValueReference[] createSerializedClosedFieldNames(ARecordType recordType) {
        UTF8StringWriter writer = new UTF8StringWriter();
        AMutableString mutableString = new AMutableString("");
        AStringSerializerDeserializer serDer = new AStringSerializerDeserializer(writer, null);
        String[] fieldNames = recordType.getFieldNames();
        IValueReference[] fieldNameReferences = new IValueReference[fieldNames.length];
        for (int i = 0; i < fieldNameReferences.length; ++i) {
            mutableString.setValue(fieldNames[i]);
            fieldNameReferences[i] = TypedRecordLazyVisitablePointable.createFieldName(mutableString, serDer);
        }
        return fieldNameReferences;
    }

    private static IValueReference createFieldName(AMutableString mutableString, AStringSerializerDeserializer serDer) {
        ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
        try {
            serDer.serialize(mutableString, storage.getDataOutput());
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
        return storage;
    }

    private static AbstractLazyVisitablePointable[] createClosedVisitables(ARecordType recordType) {
        IAType[] types = recordType.getFieldTypes();
        AbstractLazyVisitablePointable[] visitables = new AbstractLazyVisitablePointable[types.length];
        for (int i = 0; i < types.length; ++i) {
            visitables[i] = TypedRecordLazyVisitablePointable.createVisitable(types[i]);
        }
        return visitables;
    }
}

