/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.lazy;

import org.apache.asterix.om.lazy.AbstractLazyVisitablePointable;
import org.apache.asterix.om.lazy.AbstractListLazyVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FixedListLazyVisitablePointable
extends AbstractListLazyVisitablePointable {
    private final int itemSize;

    public FixedListLazyVisitablePointable(boolean tagged, AbstractCollectionType listType) {
        super(tagged, listType);
        ATypeTag itemTag = listType.getItemType().getTypeTag();
        this.currentChildTypeTag = itemTag.serialize();
        try {
            this.itemSize = NonTaggedFormatUtil.getFieldValueLength(null, -1, itemTag, false);
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void nextChild() {
        byte[] data = this.getByteArray();
        int itemOffset = this.itemsOffset + this.currentIndex * this.itemSize;
        this.currentValue.set(data, itemOffset, this.itemSize);
        ++this.currentIndex;
    }

    @Override
    public boolean isTaggedChild() {
        return false;
    }

    @Override
    AbstractLazyVisitablePointable createVisitablePointable(IAType itemType) {
        return FixedListLazyVisitablePointable.createVisitable(itemType);
    }
}

