/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.ipc.PythonDomainSocketProto;
import org.apache.asterix.external.library.AbstractLibrarySocketEvaluator;
import org.apache.asterix.external.library.ExternalLibraryManager;
import org.apache.asterix.external.library.PythonLibrary;
import org.apache.asterix.external.library.PythonLibraryEvaluatorId;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.resources.IDeallocatable;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PythonLibraryDomainSocketEvaluator
extends AbstractLibrarySocketEvaluator {
    private final ILibraryManager libMgr;
    private final Path sockPath;
    SocketChannel chan;
    ProcessHandle pid;
    private static final Logger LOGGER = LogManager.getLogger(ExternalLibraryManager.class);

    public PythonLibraryDomainSocketEvaluator(JobId jobId, PythonLibraryEvaluatorId evaluatorId, ILibraryManager libMgr, TaskAttemptId task, IWarningCollector warningCollector, SourceLocation sourceLoc, Path sockPath) {
        super(jobId, evaluatorId, task, warningCollector, sourceLoc);
        this.libMgr = libMgr;
        this.sockPath = sockPath;
    }

    @Override
    public void start() throws IOException, AsterixException {
        SocketAddress sockAddr;
        PythonLibraryEvaluatorId fnId = (PythonLibraryEvaluatorId)this.id;
        PythonLibrary library = (PythonLibrary)this.libMgr.getLibrary(fnId.getLibraryNamespace(), fnId.getLibraryName());
        String wd = library.getFile().getAbsolutePath();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            VarHandle sockEnum = lookup.in(StandardProtocolFamily.class).findStaticVarHandle(StandardProtocolFamily.class, "UNIX", StandardProtocolFamily.class);
            Class<?> domainSock = Class.forName("java.net.UnixDomainSocketAddress");
            MethodType unixDomainSockAddrType = MethodType.methodType(domainSock, Path.class);
            MethodHandle unixDomainSockAddr = lookup.findStatic(domainSock, "of", unixDomainSockAddrType);
            MethodType sockChanMethodType = MethodType.methodType(SocketChannel.class, ProtocolFamily.class);
            MethodHandle sockChanOpen = lookup.findStatic(SocketChannel.class, "open", sockChanMethodType);
            sockAddr = unixDomainSockAddr.invoke(this.sockPath);
            this.chan = sockChanOpen.invoke(sockEnum.get());
        }
        catch (Throwable e) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.LOCAL_NETWORK_ERROR, (Throwable)e, (Serializable[])new Serializable[0]);
        }
        this.chan.connect(sockAddr);
        this.proto = new PythonDomainSocketProto(Channels.newOutputStream(this.chan), this.chan, wd);
        this.proto.start();
        this.proto.helo();
        this.pid = ((PythonDomainSocketProto)this.proto).getPid();
    }

    public void deallocate() {
        try {
            if (this.proto != null) {
                this.proto.quit();
            }
            if (this.chan != null) {
                this.chan.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Caught exception exiting Python UDF:", (Throwable)e);
        }
        if (this.pid != null && this.pid.isAlive()) {
            LOGGER.error("Python UDF " + this.pid.pid() + " did not exit as expected.");
        }
    }

    static PythonLibraryDomainSocketEvaluator getInstance(IExternalFunctionInfo finfo, ILibraryManager libMgr, IHyracksTaskContext ctx, IWarningCollector warningCollector, SourceLocation sourceLoc) throws IOException, AsterixException {
        PythonLibraryEvaluatorId evaluatorId = new PythonLibraryEvaluatorId(finfo.getLibraryNamespace(), finfo.getLibraryName(), Thread.currentThread());
        PythonLibraryDomainSocketEvaluator evaluator = (PythonLibraryDomainSocketEvaluator)ctx.getStateObject((Object)evaluatorId);
        if (evaluator == null) {
            Path sockPath = Path.of(ctx.getJobletContext().getServiceContext().getAppConfig().getString((IOption)NCConfig.Option.PYTHON_DS_PATH), new String[0]);
            evaluator = new PythonLibraryDomainSocketEvaluator(ctx.getJobletContext().getJobId(), evaluatorId, libMgr, ctx.getTaskAttemptId(), warningCollector, sourceLoc, sockPath);
            ctx.getJobletContext().registerDeallocatable((IDeallocatable)evaluator);
            evaluator.start();
            ctx.setStateObject((IStateObject)evaluator);
        }
        return evaluator;
    }
}

