/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.api;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.ipc.MessageType;
import org.apache.asterix.external.library.msgpack.MsgPackPointableVisitor;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public interface IExternalLangIPCProto {
    public static void visitValueRef(IAType type, DataOutput out, IValueReference valueReference, PointableAllocator pointableAllocator, MsgPackPointableVisitor pointableVisitor, boolean visitNull) throws IOException {
        switch (type.getTypeTag()) {
            case OBJECT: {
                ARecordVisitablePointable pointable = pointableAllocator.allocateRecordValue(type);
                pointable.set(valueReference);
                pointableVisitor.visit(pointable, pointableVisitor.getTypeInfo(type, out));
                break;
            }
            case ARRAY: 
            case MULTISET: {
                AListVisitablePointable pointable = pointableAllocator.allocateListValue(type);
                pointable.set(valueReference);
                pointableVisitor.visit(pointable, pointableVisitor.getTypeInfo(type, out));
                break;
            }
            case ANY: {
                ATypeTag rtTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(valueReference.getByteArray()[valueReference.getStartOffset()]);
                IAType rtType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)rtTypeTag);
                IExternalLangIPCProto.visitValueRef(rtType, out, valueReference, pointableAllocator, pointableVisitor, visitNull);
                break;
            }
            case MISSING: 
            case NULL: {
                if (!visitNull) {
                    return;
                }
            }
            default: {
                IVisitablePointable pointable = pointableAllocator.allocateFieldValue(type);
                pointable.set(valueReference);
                pointableVisitor.visit((AFlatValuePointable)pointable, pointableVisitor.getTypeInfo(type, out));
            }
        }
    }

    public void start();

    public void helo() throws IOException, AsterixException;

    public long init(String var1, String var2, String var3) throws IOException, AsterixException;

    public ByteBuffer call(long var1, IAType[] var3, IValueReference[] var4, boolean var5) throws IOException, AsterixException;

    public ByteBuffer callMulti(long var1, ArrayBackedValueStorage var3, int var4) throws IOException, AsterixException;

    public void quit() throws HyracksDataException;

    public void receiveMsg() throws IOException, AsterixException;

    public void sendHeader(long var1, int var3) throws IOException;

    public void sendMsg(ArrayBackedValueStorage var1) throws IOException;

    public void sendMsg() throws IOException;

    public MessageType getResponseType();

    public long getRouteId();

    public DataOutputStream getSockOut();
}

