/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.bytes.ByteArrayFrontCodedList;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteBigArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class ByteArrayFrontCodedBigList
extends AbstractObjectBigList<byte[]>
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = 1L;
    protected final long n;
    protected final int ratio;
    protected final byte[][] array;
    protected transient long[][] p;

    public ByteArrayFrontCodedBigList(Iterator<byte[]> arrays, int ratio) {
        if (ratio < 1) {
            throw new IllegalArgumentException("Illegal ratio (" + ratio + ")");
        }
        byte[][] array = ByteBigArrays.EMPTY_BIG_ARRAY;
        long[][] p = LongBigArrays.EMPTY_BIG_ARRAY;
        byte[][] a = new byte[2][];
        long curSize = 0L;
        long n = 0L;
        int b = 0;
        while (arrays.hasNext()) {
            a[b] = arrays.next();
            int length = a[b].length;
            if (n % (long)ratio == 0L) {
                p = BigArrays.grow((long[][])p, (long)(n / (long)ratio + 1L));
                BigArrays.set((long[][])p, (long)(n / (long)ratio), (long)curSize);
                array = BigArrays.grow((byte[][])array, (long)(curSize + (long)ByteArrayFrontCodedList.count(length) + (long)length), (long)curSize);
                curSize += (long)ByteArrayFrontCodedList.writeInt(array, length, curSize);
                BigArrays.copyToBig((byte[])a[b], (int)0, (byte[][])array, (long)curSize, (long)length);
                curSize += (long)length;
            } else {
                int common;
                int minLength = a[1 - b].length;
                if (length < minLength) {
                    minLength = length;
                }
                for (common = 0; common < minLength && a[0][common] == a[1][common]; ++common) {
                }
                array = BigArrays.grow((byte[][])array, (long)(curSize + (long)ByteArrayFrontCodedList.count(length -= common) + (long)ByteArrayFrontCodedList.count(common) + (long)length), (long)curSize);
                curSize += (long)ByteArrayFrontCodedList.writeInt(array, length, curSize);
                curSize += (long)ByteArrayFrontCodedList.writeInt(array, common, curSize);
                BigArrays.copyToBig((byte[])a[b], (int)common, (byte[][])array, (long)curSize, (long)length);
                curSize += (long)length;
            }
            b = 1 - b;
            ++n;
        }
        this.n = n;
        this.ratio = ratio;
        this.array = BigArrays.trim((byte[][])array, (long)curSize);
        this.p = BigArrays.trim((long[][])p, (long)((n + (long)ratio - 1L) / (long)ratio));
    }

    public ByteArrayFrontCodedBigList(Collection<byte[]> c, int ratio) {
        this(c.iterator(), ratio);
    }

    public int ratio() {
        return this.ratio;
    }

    private int length(long index) {
        byte[][] array = this.array;
        int delta = (int)(index % (long)this.ratio);
        long pos = BigArrays.get((long[][])this.p, (long)(index / (long)this.ratio));
        int length = ByteArrayFrontCodedList.readInt(array, pos);
        if (delta == 0) {
            return length;
        }
        pos += (long)(ByteArrayFrontCodedList.count(length) + length);
        length = ByteArrayFrontCodedList.readInt(array, pos);
        int common = ByteArrayFrontCodedList.readInt(array, pos + (long)ByteArrayFrontCodedList.count(length));
        for (int i = 0; i < delta - 1; ++i) {
            length = ByteArrayFrontCodedList.readInt(array, pos += (long)(ByteArrayFrontCodedList.count(length) + ByteArrayFrontCodedList.count(common) + length));
            common = ByteArrayFrontCodedList.readInt(array, pos + (long)ByteArrayFrontCodedList.count(length));
        }
        return length + common;
    }

    public int arrayLength(long index) {
        this.ensureRestrictedIndex(index);
        return this.length(index);
    }

    private int extract(long index, byte[] a, int offset, int length) {
        long startPos;
        int delta = (int)(index % (long)this.ratio);
        long pos = startPos = BigArrays.get((long[][])this.p, (long)(index / (long)this.ratio));
        int arrayLength = ByteArrayFrontCodedList.readInt(this.array, pos);
        int currLen = 0;
        if (delta == 0) {
            pos = BigArrays.get((long[][])this.p, (long)(index / (long)this.ratio)) + (long)ByteArrayFrontCodedList.count(arrayLength);
            BigArrays.copyFromBig((byte[][])this.array, (long)pos, (byte[])a, (int)offset, (int)Math.min(length, arrayLength));
            return arrayLength;
        }
        int common = 0;
        for (int i = 0; i < delta; ++i) {
            long prevArrayPos = pos + (long)ByteArrayFrontCodedList.count(arrayLength) + (long)(i != 0 ? ByteArrayFrontCodedList.count(common) : 0);
            common = ByteArrayFrontCodedList.readInt(this.array, (pos = prevArrayPos + (long)arrayLength) + (long)ByteArrayFrontCodedList.count(arrayLength = ByteArrayFrontCodedList.readInt(this.array, pos)));
            int actualCommon = Math.min(common, length);
            if (actualCommon <= currLen) {
                currLen = actualCommon;
                continue;
            }
            BigArrays.copyFromBig((byte[][])this.array, (long)prevArrayPos, (byte[])a, (int)(currLen + offset), (int)(actualCommon - currLen));
            currLen = actualCommon;
        }
        if (currLen < length) {
            BigArrays.copyFromBig((byte[][])this.array, (long)(pos + (long)ByteArrayFrontCodedList.count(arrayLength) + (long)ByteArrayFrontCodedList.count(common)), (byte[])a, (int)(currLen + offset), (int)Math.min(arrayLength, length - currLen));
        }
        return arrayLength + common;
    }

    public byte[] get(long index) {
        return this.getArray(index);
    }

    public byte[] getArray(long index) {
        this.ensureRestrictedIndex(index);
        int length = this.length(index);
        byte[] a = new byte[length];
        this.extract(index, a, 0, length);
        return a;
    }

    public int get(long index, byte[] a, int offset, int length) {
        this.ensureRestrictedIndex(index);
        ByteArrays.ensureOffsetLength((byte[])a, (int)offset, (int)length);
        int arrayLength = this.extract(index, a, offset, length);
        if (length >= arrayLength) {
            return arrayLength;
        }
        return length - arrayLength;
    }

    public int get(long index, byte[] a) {
        return this.get(index, a, 0, a.length);
    }

    public long size64() {
        return this.n;
    }

    public ObjectBigListIterator<byte[]> listIterator(final long start) {
        this.ensureIndex(start);
        return new ObjectBigListIterator<byte[]>(){
            byte[] s = ByteArrays.EMPTY_ARRAY;
            long i = 0L;
            long pos = 0L;
            boolean inSync;
            {
                if (start != 0L) {
                    if (start == ByteArrayFrontCodedBigList.this.n) {
                        this.i = start;
                    } else {
                        this.pos = BigArrays.get((long[][])ByteArrayFrontCodedBigList.this.p, (long)(start / (long)ByteArrayFrontCodedBigList.this.ratio));
                        int j = (int)(start % (long)ByteArrayFrontCodedBigList.this.ratio);
                        this.i = start - (long)j;
                        while (j-- != 0) {
                            this.next();
                        }
                    }
                }
            }

            public boolean hasNext() {
                return this.i < ByteArrayFrontCodedBigList.this.n;
            }

            public boolean hasPrevious() {
                return this.i > 0L;
            }

            public long previousIndex() {
                return this.i - 1L;
            }

            public long nextIndex() {
                return this.i;
            }

            public byte[] next() {
                int length;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.i % (long)ByteArrayFrontCodedBigList.this.ratio == 0L) {
                    this.pos = BigArrays.get((long[][])ByteArrayFrontCodedBigList.this.p, (long)(this.i / (long)ByteArrayFrontCodedBigList.this.ratio));
                    length = ByteArrayFrontCodedList.readInt(ByteArrayFrontCodedBigList.this.array, this.pos);
                    this.s = ByteArrays.ensureCapacity((byte[])this.s, (int)length, (int)0);
                    BigArrays.copyFromBig((byte[][])ByteArrayFrontCodedBigList.this.array, (long)(this.pos + (long)ByteArrayFrontCodedList.count(length)), (byte[])this.s, (int)0, (int)length);
                    this.pos += (long)(length + ByteArrayFrontCodedList.count(length));
                    this.inSync = true;
                } else if (this.inSync) {
                    length = ByteArrayFrontCodedList.readInt(ByteArrayFrontCodedBigList.this.array, this.pos);
                    int common = ByteArrayFrontCodedList.readInt(ByteArrayFrontCodedBigList.this.array, this.pos + (long)ByteArrayFrontCodedList.count(length));
                    this.s = ByteArrays.ensureCapacity((byte[])this.s, (int)(length + common), (int)common);
                    BigArrays.copyFromBig((byte[][])ByteArrayFrontCodedBigList.this.array, (long)(this.pos + (long)ByteArrayFrontCodedList.count(length) + (long)ByteArrayFrontCodedList.count(common)), (byte[])this.s, (int)common, (int)length);
                    this.pos += (long)(ByteArrayFrontCodedList.count(length) + ByteArrayFrontCodedList.count(common) + length);
                    length += common;
                } else {
                    length = ByteArrayFrontCodedBigList.this.length(this.i);
                    this.s = ByteArrays.ensureCapacity((byte[])this.s, (int)length, (int)0);
                    ByteArrayFrontCodedBigList.this.extract(this.i, this.s, 0, length);
                }
                ++this.i;
                return ByteArrays.copy((byte[])this.s, (int)0, (int)length);
            }

            public byte[] previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.inSync = false;
                return ByteArrayFrontCodedBigList.this.getArray(--this.i);
            }
        };
    }

    public ByteArrayFrontCodedBigList clone() {
        return this;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[");
        for (long i = 0L; i < this.n; ++i) {
            if (i != 0L) {
                s.append(", ");
            }
            s.append(ByteArrayList.wrap(this.getArray(i)).toString());
        }
        s.append("]");
        return s.toString();
    }

    protected long[][] rebuildPointerArray() {
        long[][] p = LongBigArrays.newBigArray((long)((this.n + (long)this.ratio - 1L) / (long)this.ratio));
        byte[][] a = this.array;
        long pos = 0L;
        int skip = this.ratio - 1;
        long j = 0L;
        for (long i = 0L; i < this.n; ++i) {
            int length = ByteArrayFrontCodedList.readInt(a, pos);
            int count = ByteArrayFrontCodedList.count(length);
            if (++skip == this.ratio) {
                skip = 0;
                BigArrays.set((long[][])p, (long)j++, (long)pos);
                pos += (long)(count + length);
                continue;
            }
            pos += (long)(count + ByteArrayFrontCodedList.count(ByteArrayFrontCodedList.readInt(a, pos + (long)count)) + length);
        }
        return p;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.p = this.rebuildPointerArray();
    }
}

