/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdated;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskUpdatedEvent
implements HistoryEvent {
    private TaskUpdated datum = new TaskUpdated();

    public TaskUpdatedEvent(TaskID id, long finishTime) {
        this.datum.setTaskid((CharSequence)new Utf8(id.toString()));
        this.datum.setFinishTime(finishTime);
    }

    TaskUpdatedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (TaskUpdated)((Object)datum);
    }

    public TaskID getTaskId() {
        return TaskID.forName(this.datum.getTaskid().toString());
    }

    public long getFinishTime() {
        return this.datum.getFinishTime();
    }

    @Override
    public EventType getEventType() {
        return EventType.TASK_UPDATED;
    }
}

