/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.transactions;

import org.apache.asterix.common.config.TransactionProperties;

public class CheckpointProperties {
    private final String checkpointDirPath;
    private final int lsnThreshold;
    private final int pollFrequency;
    private final int historyToKeep;
    private final int datasetCheckpointInterval;

    public CheckpointProperties(TransactionProperties txnProperties, String nodeId) {
        this.checkpointDirPath = txnProperties.getLogDirectory(nodeId);
        this.lsnThreshold = txnProperties.getCheckpointLSNThreshold();
        this.pollFrequency = txnProperties.getCheckpointPollFrequency();
        this.historyToKeep = txnProperties.getCheckpointHistory();
        this.datasetCheckpointInterval = txnProperties.getDatasetCheckpointInterval();
    }

    public int getLsnThreshold() {
        return this.lsnThreshold;
    }

    public int getPollFrequency() {
        return this.pollFrequency;
    }

    public int getHistoryToKeep() {
        return this.historyToKeep;
    }

    public String getCheckpointDirPath() {
        return this.checkpointDirPath;
    }

    public int getDatasetCheckpointInterval() {
        return this.datasetCheckpointInterval;
    }

    public String toString() {
        return "{\"class\" : \"" + this.getClass().getSimpleName() + "\", \"checkpoint-dir-path\" : \"" + this.checkpointDirPath + "\", \"lsn-threshold\" : " + this.lsnThreshold + ", \"poll-frequency\" : " + this.pollFrequency + ", \"history-to-keep\" : " + this.historyToKeep + ", \"dataset-checkpoint-interval\" : " + this.datasetCheckpointInterval + "}";
    }
}

