/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.replication.message;

import org.apache.asterix.app.replication.message.MetadataNodeResponseMessage;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.messaging.CcIdentifiedMessage;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.replication.INCLifecycleMessage;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetadataNodeRequestMessage
extends CcIdentifiedMessage
implements INCLifecycleMessage,
INcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean export;
    private final int partitionId;

    public MetadataNodeRequestMessage(boolean export, int partitionId) {
        this.export = export;
        this.partitionId = partitionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(INcApplicationContext appContext) throws HyracksDataException, InterruptedException {
        INCMessageBroker broker = (INCMessageBroker)appContext.getServiceContext().getMessageBroker();
        Object hde = null;
        try {
            if (this.export) {
                appContext.initializeMetadata(false, this.partitionId);
                appContext.exportMetadataNodeStub();
                appContext.bindMetadataNodeStub(this.getCcId());
            } else {
                appContext.unexportMetadataNodeStub();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Failed taking over metadata", (Throwable)e);
            hde = HyracksDataException.create((Throwable)e);
        }
        finally {
            MetadataNodeResponseMessage reponse = new MetadataNodeResponseMessage(appContext.getTransactionSubsystem().getId(), this.export);
            try {
                broker.sendMessageToCC(this.getCcId(), (ICcAddressedMessage)reponse);
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Failed taking over metadata", (Throwable)e);
                hde = ExceptionUtils.suppress((Throwable)hde, (Throwable)e);
            }
        }
        if (hde != null) {
            throw HyracksDataException.create((Throwable)hde);
        }
    }

    public String toString() {
        return MetadataNodeRequestMessage.class.getSimpleName();
    }

    public INCLifecycleMessage.MessageType getType() {
        return INCLifecycleMessage.MessageType.METADATA_NODE_REQUEST;
    }
}

