/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet;

import java.util.Collections;
import java.util.Map;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.RootConverter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetReadSupport
extends ReadSupport<IValueReference> {
    private static final PrimitiveType NULL = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("NULL");

    public ReadSupport.ReadContext init(InitContext context) {
        String requestedSchemaString = context.getConfiguration().get("requested-fields");
        MessageType requestedSchema = ParquetReadSupport.getRequestedSchema(requestedSchemaString, context.getFileSchema());
        return new ReadSupport.ReadContext(requestedSchema, Collections.emptyMap());
    }

    public RecordMaterializer<IValueReference> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new ADMRecordMaterializer(readContext);
    }

    private static MessageType getRequestedSchema(String requestedSchemaString, MessageType fileSchema) {
        if ("*".equals(requestedSchemaString)) {
            return fileSchema;
        }
        Types.MessageTypeBuilder builder = Types.buildMessage();
        String[] paths = requestedSchemaString.split(",");
        for (int i = 0; i < paths.length; ++i) {
            ParquetReadSupport.buildRequestedType(paths[i].trim().split("[.]"), builder, (GroupType)fileSchema, 0);
        }
        return builder.named("asterix");
    }

    private static void buildRequestedType(String[] fieldNames, Types.GroupBuilder<?> builder, GroupType groupType, int start) {
        String fieldName = fieldNames[start].trim();
        Type type = ParquetReadSupport.getType(groupType, fieldName);
        if (type != NULL && start < fieldNames.length - 1) {
            Types.GroupBuilder innerFieldBuilder = Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL);
            ParquetReadSupport.buildRequestedType(fieldNames, innerFieldBuilder, type.asGroupType(), start + 1);
            builder.addField((Type)innerFieldBuilder.named(fieldName));
        } else {
            builder.addField(type);
        }
    }

    private static Type getType(GroupType groupType, String fieldName) {
        if (groupType.containsField(fieldName)) {
            return groupType.getType(fieldName);
        }
        return NULL;
    }

    private static class ADMRecordMaterializer
    extends RecordMaterializer<IValueReference> {
        private final RootConverter rootConverter;

        public ADMRecordMaterializer(ReadSupport.ReadContext readContext) {
            this.rootConverter = new RootConverter((GroupType)readContext.getRequestedSchema());
        }

        public IValueReference getCurrentRecord() {
            return this.rootConverter.getRecord();
        }

        public GroupConverter getRootConverter() {
            return this.rootConverter;
        }
    }
}

