/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.fulltext;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.AbstractFullTextFilterEvaluatorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.FullTextFilterType;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextFilterEvaluator;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.StopwordsFullTextFilterEvaluator;

public class StopwordsFullTextFilterEvaluatorFactory
extends AbstractFullTextFilterEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<String> stopwordList;
    private static final String STOPWORDS_FILTER_NAME = "stopwordsFilterName";
    private static final String STOPWORDS_LIST = "stopwordsList";

    public StopwordsFullTextFilterEvaluatorFactory(String name, ImmutableList<String> stopwordList) {
        super(name, FullTextFilterType.STOPWORDS);
        this.stopwordList = stopwordList;
    }

    @Override
    public IFullTextFilterEvaluator createFullTextFilterEvaluator() {
        return new StopwordsFullTextFilterEvaluator(this.name, this.stopwordList);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.put(STOPWORDS_FILTER_NAME, this.name);
        ArrayNode stopwordsArrayNode = OBJECT_MAPPER.createArrayNode();
        for (String s : this.stopwordList) {
            stopwordsArrayNode.add(s);
        }
        json.set(STOPWORDS_LIST, (JsonNode)stopwordsArrayNode);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        String name = json.get(STOPWORDS_FILTER_NAME).asText();
        ImmutableList.Builder stopwordsBuilder = ImmutableList.builder();
        JsonNode stopwordsArrayNode = json.get(STOPWORDS_LIST);
        for (int i = 0; i < stopwordsArrayNode.size(); ++i) {
            stopwordsBuilder.add((Object)stopwordsArrayNode.get(i).asText());
        }
        ImmutableList stopwords = stopwordsBuilder.build();
        return new StopwordsFullTextFilterEvaluatorFactory(name, (ImmutableList<String>)stopwords);
    }
}

