/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SelectInSubplanBranchCreator {
    private static final List<IAlgebricksConstantValue> zerosAsAsterixConstants = Arrays.asList(new AsterixConstantValue((IAObject)new AInt64(0L)), new AsterixConstantValue((IAObject)new AInt32(0)), new AsterixConstantValue((IAObject)new AInt16(0)), new AsterixConstantValue((IAObject)new AInt8(0)));
    private IOptimizationContext context;
    private SourceLocation sourceLocation;
    private SelectOperator originalSelectRoot;

    public SelectOperator createSelect(SelectOperator originalSelect, IOptimizationContext context) throws AlgebricksException {
        this.sourceLocation = originalSelect.getSourceLocation();
        this.originalSelectRoot = originalSelect;
        this.context = context;
        if (!((ILogicalOperator)((Mutable)originalSelect.getInputs().get(0)).getValue()).getOperatorTag().equals((Object)LogicalOperatorTag.SUBPLAN) || !((ILogicalExpression)originalSelect.getCondition().getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.VARIABLE)) {
            return null;
        }
        LogicalVariable originalSelectVar = ((VariableReferenceExpression)originalSelect.getCondition().getValue()).getVariableReference();
        SubplanOperator subplanOperator = (SubplanOperator)((Mutable)originalSelect.getInputs().get(0)).getValue();
        ArrayList subplanProducedVars = new ArrayList();
        VariableUtilities.getProducedVariables((ILogicalOperator)subplanOperator, subplanProducedVars);
        if (subplanProducedVars.size() != 1 || !((LogicalVariable)subplanProducedVars.get(0)).equals((Object)originalSelectVar)) {
            return null;
        }
        return this.traverseSubplanBranch(subplanOperator);
    }

    public SelectOperator getOriginalSelect() {
        return this.originalSelectRoot;
    }

    private SelectOperator traverseSubplanBranch(SubplanOperator subplanOperator) throws AlgebricksException {
        if (subplanOperator.getNestedPlans().size() > 1 || ((ILogicalPlan)subplanOperator.getNestedPlans().get(0)).getRoots().size() > 1) {
            return null;
        }
        ILogicalOperator workingSubplanRoot = (ILogicalOperator)((Mutable)((ILogicalPlan)subplanOperator.getNestedPlans().get(0)).getRoots().get(0)).getValue();
        if (!workingSubplanRoot.getOperatorTag().equals((Object)LogicalOperatorTag.AGGREGATE)) {
            return null;
        }
        AggregateOperator workingSubplanRootAsAggregate = (AggregateOperator)workingSubplanRoot;
        SelectOperator optimizableSelect = null;
        for (Mutable opInput : workingSubplanRoot.getInputs()) {
            ILogicalOperator subplanOrSelect = this.findSubplanOrSelect((ILogicalOperator)opInput.getValue());
            if (subplanOrSelect == null) {
                return null;
            }
            if (subplanOrSelect.getOperatorTag().equals((Object)LogicalOperatorTag.SUBPLAN)) {
                optimizableSelect = this.traverseSubplanBranch((SubplanOperator)subplanOrSelect);
                continue;
            }
            optimizableSelect = (SelectOperator)subplanOrSelect;
            break;
        }
        if (optimizableSelect == null) {
            return null;
        }
        SelectOperator newSelectOperator = new SelectOperator(optimizableSelect.getCondition(), optimizableSelect.getRetainMissing(), optimizableSelect.getMissingPlaceholderVariable());
        if ((newSelectOperator = this.normalizeSelectCondition(workingSubplanRootAsAggregate, newSelectOperator, (ILogicalOperator)((Mutable)subplanOperator.getInputs().get(0)).getValue())) == null) {
            return null;
        }
        newSelectOperator.setSourceLocation(this.sourceLocation);
        newSelectOperator.setExecutionMode(optimizableSelect.getExecutionMode());
        SelectOperator workingOriginalOperator = optimizableSelect;
        SelectOperator workingNewOperator = newSelectOperator;
        UnnestOperator bottommostNewUnnest = null;
        while (!workingOriginalOperator.getOperatorTag().equals((Object)LogicalOperatorTag.NESTEDTUPLESOURCE)) {
            if (workingOriginalOperator.getInputs().isEmpty()) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, workingSubplanRoot.getSourceLocation(), new Serializable[]{"NESTED-TUPLE-SOURCE expected in nested plan branch, but not found."});
            }
            switch (workingOriginalOperator.getOperatorTag()) {
                case UNNEST: {
                    UnnestOperator originalUnnest = (UnnestOperator)workingOriginalOperator;
                    UnnestOperator newUnnest = new UnnestOperator(originalUnnest.getVariable(), originalUnnest.getExpressionRef());
                    newUnnest.setSourceLocation(this.sourceLocation);
                    workingNewOperator.getInputs().add(new MutableObject((Object)newUnnest));
                    workingNewOperator = newUnnest;
                    bottommostNewUnnest = (UnnestOperator)workingNewOperator;
                    break;
                }
                case ASSIGN: {
                    AssignOperator originalAssign = (AssignOperator)workingOriginalOperator;
                    AssignOperator newAssign = new AssignOperator(originalAssign.getVariables(), originalAssign.getExpressions());
                    newAssign.setSourceLocation(this.sourceLocation);
                    workingNewOperator.getInputs().add(new MutableObject((Object)newAssign));
                    workingNewOperator = newAssign;
                    break;
                }
                case SUBPLAN: {
                    return null;
                }
                case AGGREGATE: 
                case SELECT: {
                    break;
                }
                default: {
                    return null;
                }
            }
            workingOriginalOperator = (ILogicalOperator)((Mutable)workingOriginalOperator.getInputs().get(0)).getValue();
        }
        if (this.isUniversalQuantification(workingSubplanRootAsAggregate) && !this.isArrayNonEmptyConjunctIncluded(bottommostNewUnnest, subplanOperator)) {
            return null;
        }
        bottommostNewUnnest.getInputs().addAll(subplanOperator.getInputs());
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)newSelectOperator, (ITypingContext)this.context);
        return newSelectOperator;
    }

    private boolean isUniversalQuantification(AggregateOperator workingSubplanRoot) throws CompilationException {
        AggregateFunctionCallExpression aggregateFunctionCallExpression = (AggregateFunctionCallExpression)((Mutable)workingSubplanRoot.getExpressions().get(0)).getValue();
        if (aggregateFunctionCallExpression.getFunctionIdentifier().equals((Object)BuiltinFunctions.EMPTY_STREAM)) {
            return true;
        }
        if (aggregateFunctionCallExpression.getFunctionIdentifier().equals((Object)BuiltinFunctions.NON_EMPTY_STREAM)) {
            return false;
        }
        throw new CompilationException(ErrorCode.COMPILATION_ERROR, workingSubplanRoot.getSourceLocation(), new Serializable[]{"Unexpected aggregate function: " + aggregateFunctionCallExpression.getFunctionIdentifier()});
    }

    private boolean isArrayNonEmptyConjunctIncluded(UnnestOperator firstUnnestInNTS, SubplanOperator subplanOperator) {
        ArrayList conjunctsFromSelect;
        UnnestingFunctionCallExpression unnestFunction = (UnnestingFunctionCallExpression)firstUnnestInNTS.getExpressionRef().getValue();
        VariableReferenceExpression unnestVarExpr = (VariableReferenceExpression)((Mutable)unnestFunction.getArguments().get(0)).getValue();
        LogicalVariable arrayVariable = unnestVarExpr.getVariableReference();
        if (!((ILogicalOperator)((Mutable)subplanOperator.getInputs().get(0)).getValue()).getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
            return false;
        }
        SelectOperator subplanInputOperator = (SelectOperator)((Mutable)subplanOperator.getInputs().get(0)).getValue();
        ILogicalExpression selectCondExpr = (ILogicalExpression)subplanInputOperator.getCondition().getValue();
        if (selectCondExpr.splitIntoConjuncts(conjunctsFromSelect = new ArrayList())) {
            for (Mutable mutableConjuct : conjunctsFromSelect) {
                ILogicalExpression workingConjunct = (ILogicalExpression)mutableConjuct.getValue();
                if (!workingConjunct.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || !this.analyzeConjunctForArrayNonEmptiness(arrayVariable, (ScalarFunctionCallExpression)workingConjunct)) continue;
                return true;
            }
            return false;
        }
        if (!selectCondExpr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
            return false;
        }
        return this.analyzeConjunctForArrayNonEmptiness(arrayVariable, (ScalarFunctionCallExpression)selectCondExpr);
    }

    private boolean analyzeConjunctForArrayNonEmptiness(LogicalVariable arrayVariable, ScalarFunctionCallExpression workingSelectCondExpr) {
        if (workingSelectCondExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.GT)) {
            ILogicalExpression firstArg = (ILogicalExpression)((Mutable)workingSelectCondExpr.getArguments().get(0)).getValue();
            ILogicalExpression secondArg = (ILogicalExpression)((Mutable)workingSelectCondExpr.getArguments().get(1)).getValue();
            if (firstArg.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) && ((ScalarFunctionCallExpression)firstArg).getFunctionIdentifier().equals((Object)BuiltinFunctions.LEN)) {
                ScalarFunctionCallExpression lenFunction = (ScalarFunctionCallExpression)firstArg;
                ArrayList usedVariables = new ArrayList();
                lenFunction.getUsedVariables(usedVariables);
                return usedVariables.contains(arrayVariable) && secondArg.getExpressionTag().equals((Object)LogicalExpressionTag.CONSTANT) && zerosAsAsterixConstants.contains(((ConstantExpression)secondArg).getValue());
            }
        } else if (workingSelectCondExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.LT)) {
            ILogicalExpression firstArg = (ILogicalExpression)((Mutable)workingSelectCondExpr.getArguments().get(0)).getValue();
            ILogicalExpression secondArg = (ILogicalExpression)((Mutable)workingSelectCondExpr.getArguments().get(1)).getValue();
            if (secondArg.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) && ((ScalarFunctionCallExpression)secondArg).getFunctionIdentifier().equals((Object)BuiltinFunctions.LEN)) {
                ScalarFunctionCallExpression lenFunction = (ScalarFunctionCallExpression)secondArg;
                ArrayList usedVariables = new ArrayList();
                lenFunction.getUsedVariables(usedVariables);
                return usedVariables.contains(arrayVariable) && firstArg.getExpressionTag().equals((Object)LogicalExpressionTag.CONSTANT) && zerosAsAsterixConstants.contains(((ConstantExpression)firstArg).getValue());
            }
        }
        return false;
    }

    private SelectOperator normalizeSelectCondition(AggregateOperator aggregateOperator, SelectOperator selectOperator, ILogicalOperator subplanInputOperator) throws AlgebricksException {
        if (!this.isUniversalQuantification(aggregateOperator)) {
            return selectOperator;
        }
        if (!subplanInputOperator.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
            return null;
        }
        ScalarFunctionCallExpression notFunction = (ScalarFunctionCallExpression)selectOperator.getCondition().getValue();
        if (!notFunction.getFunctionIdentifier().equals((Object)BuiltinFunctions.NOT)) {
            return selectOperator;
        }
        ScalarFunctionCallExpression ifMissingOrNullFunction = (ScalarFunctionCallExpression)((Mutable)notFunction.getArguments().get(0)).getValue();
        if (!ifMissingOrNullFunction.getFunctionIdentifier().equals((Object)BuiltinFunctions.IF_MISSING_OR_NULL)) {
            return selectOperator;
        }
        MutableObject newSelectCondition = new MutableObject((Object)((ILogicalExpression)((Mutable)ifMissingOrNullFunction.getArguments().get(0)).getValue()).cloneExpression());
        return new SelectOperator((Mutable)newSelectCondition, selectOperator.getRetainMissing(), selectOperator.getMissingPlaceholderVariable());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ILogicalOperator findSubplanOrSelect(ILogicalOperator operator) {
        if (operator.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
            SelectOperator selectOperator = (SelectOperator)operator;
            ILogicalExpression selectCondExpr = (ILogicalExpression)selectOperator.getCondition().getValue();
            if (selectCondExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                ILogicalExpression finalExpr;
                ScalarFunctionCallExpression notFunction = (ScalarFunctionCallExpression)selectOperator.getCondition().getValue();
                if (!notFunction.getFunctionIdentifier().equals((Object)BuiltinFunctions.NOT)) return selectOperator;
                ScalarFunctionCallExpression ifMissingOrNullFunction = (ScalarFunctionCallExpression)((Mutable)notFunction.getArguments().get(0)).getValue();
                if (ifMissingOrNullFunction.getFunctionIdentifier().equals((Object)BuiltinFunctions.IF_MISSING_OR_NULL) && (finalExpr = (ILogicalExpression)((Mutable)ifMissingOrNullFunction.getArguments().get(0)).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                    return selectOperator;
                }
            }
        } else if (operator.getOperatorTag().equals((Object)LogicalOperatorTag.SUBPLAN)) {
            return operator;
        }
        if (!operator.getInputs().isEmpty()) return this.findSubplanOrSelect((ILogicalOperator)((Mutable)operator.getInputs().get(0)).getValue());
        return null;
    }
}

