/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.arraylist;

public class LongArrayList {
    private long[] data;
    private int size;
    private int first;
    private final int growth;

    public LongArrayList(int initialCapacity, int growth) {
        this.data = new long[initialCapacity];
        this.size = 0;
        this.first = 0;
        this.growth = growth;
    }

    public int size() {
        return this.size;
    }

    public int first() {
        return this.first;
    }

    public void addFirst(long i) {
        long[] newData = new long[this.data.length + 1];
        System.arraycopy(this.data, 0, newData, 0, this.first);
        System.arraycopy(this.data, this.first, newData, this.first + 1, this.size - this.first);
        this.data = newData;
        this.data[this.first] = i;
        ++this.size;
    }

    public void add(long i) {
        if (this.size == this.data.length) {
            long[] newData = new long[this.data.length + this.growth];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.size++] = i;
    }

    public void removeLast() {
        if (this.size > 0) {
            --this.size;
        }
    }

    public long getLast() {
        return this.data[this.size - 1];
    }

    public long get(int i) {
        return this.data[i];
    }

    public void set(int i, long value) {
        this.data[i] = value;
    }

    public long getFirst() {
        return this.data[this.first];
    }

    public void moveFirst() {
        ++this.first;
    }

    public void clear() {
        this.size = 0;
        this.first = 0;
    }

    public boolean isLast() {
        return this.size == this.first;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

