/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class RemoveRedundantProjectionRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (op1.getOperatorTag() == LogicalOperatorTag.PROJECT) {
            Mutable opRef2 = (Mutable)op1.getInputs().get(0);
            AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
            if (op2.getOperatorTag() != LogicalOperatorTag.PROJECT) {
                return false;
            }
            ProjectOperator pi2 = (ProjectOperator)op2;
            opRef2.setValue((Object)((ILogicalOperator)((Mutable)pi2.getInputs().get(0)).getValue()));
        } else {
            if (op1.getInputs().size() <= 0) {
                return false;
            }
            Mutable opRef2 = (Mutable)op1.getInputs().get(0);
            AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
            if (op2.getOperatorTag() != LogicalOperatorTag.PROJECT) {
                return false;
            }
            if (op2.getInputs().size() <= 0) {
                return false;
            }
            Mutable opRef3 = (Mutable)op2.getInputs().get(0);
            AbstractLogicalOperator op3 = (AbstractLogicalOperator)opRef3.getValue();
            ArrayList liveVars2 = new ArrayList();
            ArrayList liveVars3 = new ArrayList();
            VariableUtilities.getLiveVariables((ILogicalOperator)op2, liveVars2);
            VariableUtilities.getLiveVariables((ILogicalOperator)op3, liveVars3);
            if (!VariableUtilities.varListEqualUnordered(liveVars2, liveVars3)) {
                return false;
            }
            opRef2.setValue((Object)op3);
        }
        return true;
    }
}

