/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.BigList;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.objects.AbstractReferenceBigList;
import it.unimi.dsi.fastutil.objects.ObjectBigArrays;
import it.unimi.dsi.fastutil.objects.ObjectBigListIterator;
import it.unimi.dsi.fastutil.objects.ObjectBigListIterators;
import it.unimi.dsi.fastutil.objects.ObjectBigSpliterators;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import it.unimi.dsi.fastutil.objects.ReferenceBigArrayBigList;
import it.unimi.dsi.fastutil.objects.ReferenceBigList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.stream.Collector;

public class ReferenceBigArrayBigList<K>
extends AbstractReferenceBigList<K>
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353131L;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected final boolean wrapped;
    protected transient K[][] a;
    protected long size;
    private static final Collector<Object, ?, ReferenceBigArrayBigList<Object>> TO_LIST_COLLECTOR = Collector.of(ReferenceBigArrayBigList::new, ReferenceBigArrayBigList::add, ReferenceBigArrayBigList::combine, new Collector.Characteristics[0]);

    protected ReferenceBigArrayBigList(K[][] a, boolean dummy) {
        this.a = a;
        this.wrapped = true;
    }

    public ReferenceBigArrayBigList(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = capacity == 0L ? ObjectBigArrays.EMPTY_BIG_ARRAY : ObjectBigArrays.newBigArray((long)capacity);
        this.wrapped = false;
    }

    public ReferenceBigArrayBigList() {
        this.a = ObjectBigArrays.DEFAULT_EMPTY_BIG_ARRAY;
        this.wrapped = false;
    }

    public ReferenceBigArrayBigList(ReferenceCollection<? extends K> c) {
        this(Size64.sizeOf(c));
        if (c instanceof ReferenceBigList) {
            this.size = Size64.sizeOf(c);
            ((ReferenceBigList)c).getElements(0L, this.a, 0L, this.size);
        } else {
            ObjectIterator<? extends K> i = c.iterator();
            while (i.hasNext()) {
                this.add(i.next());
            }
        }
    }

    public ReferenceBigArrayBigList(Collection<? extends K> c) {
        this(Size64.sizeOf(c));
        if (c instanceof ReferenceBigList) {
            this.size = Size64.sizeOf(c);
            ((ReferenceBigList)c).getElements(0L, this.a, 0L, this.size);
        } else {
            Iterator<K> i = c.iterator();
            while (i.hasNext()) {
                this.add(i.next());
            }
        }
    }

    public ReferenceBigArrayBigList(ReferenceBigList<? extends K> l) {
        this(l.size64());
        this.size = l.size64();
        l.getElements(0L, this.a, 0L, this.size);
    }

    public ReferenceBigArrayBigList(K[][] a) {
        this(a, 0L, BigArrays.length((Object[][])a));
    }

    public ReferenceBigArrayBigList(K[][] a, long offset, long length) {
        this(length);
        BigArrays.copy((Object[][])a, (long)offset, (Object[][])this.a, (long)0L, (long)length);
        this.size = length;
    }

    public ReferenceBigArrayBigList(Iterator<? extends K> i) {
        this();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public ReferenceBigArrayBigList(ObjectIterator<? extends K> i) {
        this();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public K[][] elements() {
        return this.a;
    }

    public static <K> ReferenceBigArrayBigList<K> wrap(K[][] a, long length) {
        if (length > BigArrays.length((Object[][])a)) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + BigArrays.length((Object[][])a) + ")");
        }
        ReferenceBigArrayBigList<K> l = new ReferenceBigArrayBigList<K>(a, false);
        l.size = length;
        return l;
    }

    public static <K> ReferenceBigArrayBigList<K> wrap(K[][] a) {
        return ReferenceBigArrayBigList.wrap(a, BigArrays.length((Object[][])a));
    }

    public static <K> ReferenceBigArrayBigList<K> of() {
        return new ReferenceBigArrayBigList<K>();
    }

    @SafeVarargs
    public static <K> ReferenceBigArrayBigList<K> of(K ... init) {
        return ReferenceBigArrayBigList.wrap(BigArrays.wrap((Object[])init));
    }

    private ReferenceBigArrayBigList<K> combine(ReferenceBigArrayBigList<? extends K> toAddFrom) {
        this.addAll(toAddFrom);
        return this;
    }

    public static <K> Collector<K, ?, ReferenceBigArrayBigList<K>> toBigList() {
        return TO_LIST_COLLECTOR;
    }

    public static <K> Collector<K, ?, ReferenceBigArrayBigList<K>> toBigListWithExpectedSize(long expectedSize) {
        return Collector.of(() -> new ReferenceBigArrayBigList(expectedSize), ReferenceBigArrayBigList::add, ReferenceBigArrayBigList::combine, new Collector.Characteristics[0]);
    }

    public void ensureCapacity(long capacity) {
        if (capacity <= BigArrays.length((Object[][])this.a) || this.a == ObjectBigArrays.DEFAULT_EMPTY_BIG_ARRAY) {
            return;
        }
        if (this.wrapped) {
            this.a = BigArrays.forceCapacity((Object[][])this.a, (long)capacity, (long)this.size);
        } else if (capacity > BigArrays.length((Object[][])this.a)) {
            Object[][] t = ObjectBigArrays.newBigArray((long)capacity);
            BigArrays.copy((Object[][])this.a, (long)0L, (Object[][])t, (long)0L, (long)this.size);
            this.a = t;
        }
        assert (this.size <= BigArrays.length((Object[][])this.a));
    }

    private void grow(long capacity) {
        long oldLength = BigArrays.length((Object[][])this.a);
        if (capacity <= oldLength) {
            return;
        }
        if (this.a != ObjectBigArrays.DEFAULT_EMPTY_BIG_ARRAY) {
            capacity = Math.max(oldLength + (oldLength >> 1), capacity);
        } else if (capacity < 10L) {
            capacity = 10L;
        }
        if (this.wrapped) {
            this.a = BigArrays.forceCapacity((Object[][])this.a, (long)capacity, (long)this.size);
        } else {
            Object[][] t = ObjectBigArrays.newBigArray((long)capacity);
            BigArrays.copy((Object[][])this.a, (long)0L, (Object[][])t, (long)0L, (long)this.size);
            this.a = t;
        }
        assert (this.size <= BigArrays.length((Object[][])this.a));
    }

    @Override
    public void add(long index, K k) {
        this.ensureIndex(index);
        this.grow(this.size + 1L);
        if (index != this.size) {
            BigArrays.copy((Object[][])this.a, (long)index, (Object[][])this.a, (long)(index + 1L), (long)(this.size - index));
        }
        BigArrays.set((Object[][])this.a, (long)index, k);
        ++this.size;
        assert (this.size <= BigArrays.length((Object[][])this.a));
    }

    @Override
    public boolean add(K k) {
        this.grow(this.size + 1L);
        BigArrays.set((Object[][])this.a, (long)this.size++, k);
        assert (this.size <= BigArrays.length((Object[][])this.a));
        return true;
    }

    public K get(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return (K)BigArrays.get((Object[][])this.a, (long)index);
    }

    @Override
    public long indexOf(Object k) {
        for (long i = 0L; i < this.size; ++i) {
            if (k != BigArrays.get((Object[][])this.a, (long)i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(Object k) {
        long i = this.size;
        while (i-- != 0L) {
            if (k != BigArrays.get((Object[][])this.a, (long)i)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public K remove(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        Object old = BigArrays.get((Object[][])this.a, (long)index);
        --this.size;
        if (index != this.size) {
            BigArrays.copy((Object[][])this.a, (long)(index + 1L), (Object[][])this.a, (long)index, (long)(this.size - index));
        }
        BigArrays.set((Object[][])this.a, (long)this.size, null);
        assert (this.size <= BigArrays.length((Object[][])this.a));
        return (K)old;
    }

    @Override
    public boolean remove(Object k) {
        long index = this.indexOf(k);
        if (index == -1L) {
            return false;
        }
        this.remove(index);
        assert (this.size <= BigArrays.length((Object[][])this.a));
        return true;
    }

    @Override
    public K set(long index, K k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        Object old = BigArrays.get((Object[][])this.a, (long)index);
        BigArrays.set((Object[][])this.a, (long)index, k);
        return (K)old;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        K[] s = null;
        K[] d = null;
        int ss = -1;
        int sd = 0x8000000;
        int ds = -1;
        int dd = 0x8000000;
        for (long i = 0L; i < this.size; ++i) {
            if (sd == 0x8000000) {
                sd = 0;
                s = this.a[++ss];
            }
            if (!c.contains(s[sd])) {
                if (dd == 0x8000000) {
                    d = this.a[++ds];
                    dd = 0;
                }
                d[dd++] = s[sd];
            }
            ++sd;
        }
        long j = BigArrays.index((int)ds, (int)dd);
        BigArrays.fill((Object[][])this.a, (long)j, (long)this.size, null);
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public boolean addAll(long index, Collection<? extends K> c) {
        if (c instanceof ReferenceList) {
            return this.addAll(index, (ReferenceList)c);
        }
        if (c instanceof ReferenceBigList) {
            return this.addAll(index, (ReferenceBigList)c);
        }
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + (long)n);
        BigArrays.copy((Object[][])this.a, (long)index, (Object[][])this.a, (long)(index + (long)n), (long)(this.size - index));
        Iterator<K> i = c.iterator();
        this.size += (long)n;
        assert (this.size <= BigArrays.length((Object[][])this.a));
        while (n-- != 0) {
            BigArrays.set((Object[][])this.a, (long)index++, i.next());
        }
        return true;
    }

    @Override
    public boolean addAll(long index, ReferenceBigList<? extends K> list) {
        this.ensureIndex(index);
        long n = list.size64();
        if (n == 0L) {
            return false;
        }
        this.grow(this.size + n);
        BigArrays.copy((Object[][])this.a, (long)index, (Object[][])this.a, (long)(index + n), (long)(this.size - index));
        list.getElements(0L, this.a, index, n);
        this.size += n;
        assert (this.size <= BigArrays.length((Object[][])this.a));
        return true;
    }

    @Override
    public boolean addAll(long index, ReferenceList<? extends K> list) {
        int l;
        int n;
        this.ensureIndex(index);
        if (n == 0) {
            return false;
        }
        this.grow(this.size + (long)n);
        BigArrays.copy((Object[][])this.a, (long)index, (Object[][])this.a, (long)(index + (long)n), (long)(this.size - index));
        this.size += (long)n;
        assert (this.size <= BigArrays.length((Object[][])this.a));
        int segment = BigArrays.segment((long)index);
        int displ = BigArrays.displacement((long)index);
        int pos = 0;
        for (n = list.size(); n > 0; n -= l) {
            l = Math.min(this.a[segment].length - displ, n);
            list.getElements(pos, this.a[segment], displ, l);
            if ((displ += l) == 0x8000000) {
                displ = 0;
                ++segment;
            }
            pos += l;
        }
        return true;
    }

    @Override
    public void clear() {
        BigArrays.fill((Object[][])this.a, (long)0L, (long)this.size, null);
        this.size = 0L;
        assert (this.size <= BigArrays.length((Object[][])this.a));
    }

    public long size64() {
        return this.size;
    }

    @Override
    public void size(long size) {
        if (size > BigArrays.length((Object[][])this.a)) {
            this.a = BigArrays.forceCapacity((Object[][])this.a, (long)size, (long)this.size);
        }
        if (size > this.size) {
            BigArrays.fill((Object[][])this.a, (long)this.size, (long)size, null);
        } else {
            BigArrays.fill((Object[][])this.a, (long)size, (long)this.size, null);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void trim() {
        this.trim(0L);
    }

    public void trim(long n) {
        long arrayLength = BigArrays.length((Object[][])this.a);
        if (n >= arrayLength || this.size == arrayLength) {
            return;
        }
        this.a = BigArrays.trim((Object[][])this.a, (long)Math.max(n, this.size));
        assert (this.size <= BigArrays.length((Object[][])this.a));
    }

    @Override
    public ReferenceBigList<K> subList(long from, long to) {
        if (from == 0L && to == this.size64()) {
            return this;
        }
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new SubList(from, to);
    }

    @Override
    public void getElements(long from, Object[][] a, long offset, long length) {
        BigArrays.copy((Object[][])this.a, (long)from, (Object[][])a, (long)offset, (long)length);
    }

    @Override
    public void removeElements(long from, long to) {
        BigArrays.ensureFromTo((long)this.size, (long)from, (long)to);
        BigArrays.copy((Object[][])this.a, (long)to, (Object[][])this.a, (long)from, (long)(this.size - to));
        this.size -= to - from;
        BigArrays.fill((Object[][])this.a, (long)this.size, (long)(this.size + to - from), null);
    }

    @Override
    public void addElements(long index, K[][] a, long offset, long length) {
        this.ensureIndex(index);
        BigArrays.ensureOffsetLength((Object[][])a, (long)offset, (long)length);
        this.grow(this.size + length);
        BigArrays.copy((Object[][])this.a, (long)index, (Object[][])this.a, (long)(index + length), (long)(this.size - index));
        BigArrays.copy((Object[][])a, (long)offset, (Object[][])this.a, (long)index, (long)length);
        this.size += length;
    }

    @Override
    public void setElements(long index, Object[][] a, long offset, long length) {
        BigArrays.copy((Object[][])a, (long)offset, (Object[][])this.a, (long)index, (long)length);
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        for (long i = 0L; i < this.size; ++i) {
            action.accept(BigArrays.get((Object[][])this.a, (long)i));
        }
    }

    @Override
    public ObjectBigListIterator<K> listIterator(final long index) {
        this.ensureIndex(index);
        return new ObjectBigListIterator<K>(){
            long pos;
            long last;
            {
                this.pos = index;
                this.last = -1L;
            }

            public boolean hasNext() {
                return this.pos < ReferenceBigArrayBigList.this.size;
            }

            public boolean hasPrevious() {
                return this.pos > 0L;
            }

            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)this.last);
            }

            public K previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)this.pos);
            }

            public long nextIndex() {
                return this.pos;
            }

            public long previousIndex() {
                return this.pos - 1L;
            }

            public void add(K k) {
                ReferenceBigArrayBigList.this.add(this.pos++, k);
                this.last = -1L;
            }

            public void set(K k) {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                ReferenceBigArrayBigList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1L) {
                    throw new IllegalStateException();
                }
                ReferenceBigArrayBigList.this.remove(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1L;
            }

            public void forEachRemaining(Consumer<? super K> action) {
                while (this.pos < ReferenceBigArrayBigList.this.size) {
                    ++this.pos;
                    this.last = this.last;
                    action.accept(BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)this.last));
                }
            }

            public long back(long n) {
                if (n < 0L) {
                    throw new IllegalArgumentException("Argument must be nonnegative: " + n);
                }
                long remaining = ReferenceBigArrayBigList.this.size - this.pos;
                if (n < remaining) {
                    this.pos -= n;
                } else {
                    n = remaining;
                    this.pos = 0L;
                }
                this.last = this.pos;
                return n;
            }

            public long skip(long n) {
                if (n < 0L) {
                    throw new IllegalArgumentException("Argument must be nonnegative: " + n);
                }
                long remaining = ReferenceBigArrayBigList.this.size - this.pos;
                if (n < remaining) {
                    this.pos += n;
                } else {
                    n = remaining;
                    this.pos = ReferenceBigArrayBigList.this.size;
                }
                this.last = this.pos - 1L;
                return n;
            }
        };
    }

    @Override
    public ObjectSpliterator<K> spliterator() {
        return new Spliterator();
    }

    public ReferenceBigArrayBigList<K> clone() {
        ReferenceBigArrayBigList<K> c;
        if (this.getClass() == ReferenceBigArrayBigList.class) {
            c = new ReferenceBigArrayBigList<K>(this.size);
            c.size = this.size;
        } else {
            try {
                c = (ReferenceBigArrayBigList<K>)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
            c.a = ObjectBigArrays.newBigArray((long)this.size);
        }
        BigArrays.copy((Object[][])this.a, (long)0L, (Object[][])c.a, (long)0L, (long)this.size);
        return c;
    }

    public boolean equals(ReferenceBigArrayBigList<K> l) {
        if (l == this) {
            return true;
        }
        long s = this.size64();
        if (s != l.size64()) {
            return false;
        }
        Object a1 = this.a;
        Object a2 = l.a;
        if (a1 == a2) {
            return true;
        }
        while (s-- != 0L) {
            if (BigArrays.get((Object[][])a1, (long)s) == BigArrays.get((Object[][])a2, (long)s)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof BigList)) {
            return false;
        }
        if (o instanceof ReferenceBigArrayBigList) {
            return this.equals((ReferenceBigArrayBigList)o);
        }
        if (o instanceof SubList) {
            return ((SubList)o).equals(this);
        }
        return super.equals(o);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int i = 0;
        while ((long)i < this.size) {
            s.writeObject(BigArrays.get((Object[][])this.a, (long)i));
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = ObjectBigArrays.newBigArray((long)this.size);
        int i = 0;
        while ((long)i < this.size) {
            BigArrays.set((Object[][])this.a, (long)i, (Object)s.readObject());
            ++i;
        }
    }

    private class SubList
    extends AbstractReferenceBigList.ReferenceRandomAccessSubList<K> {
        private static final long serialVersionUID = -3185226345314976296L;

        protected SubList(long from, long to) {
            super(ReferenceBigArrayBigList.this, from, to);
        }

        private K[][] getParentArray() {
            return ReferenceBigArrayBigList.this.a;
        }

        @Override
        public K get(long i) {
            this.ensureRestrictedIndex(i);
            return BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)(i + this.from));
        }

        @Override
        public ObjectBigListIterator<K> listIterator(long index) {
            return new SubListIterator(index);
        }

        @Override
        public ObjectSpliterator<K> spliterator() {
            return new SubListSpliterator();
        }

        boolean contentsEquals(K[][] otherA, long otherAFrom, long otherATo) {
            if (ReferenceBigArrayBigList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return true;
            }
            if (otherATo - otherAFrom != this.size64()) {
                return false;
            }
            long pos = this.to;
            long otherPos = otherATo;
            while (--pos >= this.from) {
                if (BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)pos) == BigArrays.get((Object[][])otherA, (long)(--otherPos))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof BigList)) {
                return false;
            }
            if (o instanceof ReferenceBigArrayBigList) {
                ReferenceBigArrayBigList other = (ReferenceBigArrayBigList)o;
                return this.contentsEquals(other.a, 0L, other.size64());
            }
            if (o instanceof SubList) {
                SubList other = (SubList)o;
                return this.contentsEquals(other.getParentArray(), other.from, other.to);
            }
            return super.equals(o);
        }

        private final class SubListIterator
        extends ObjectBigListIterators.AbstractIndexBasedBigListIterator<K> {
            SubListIterator(long index) {
                super(0L, index);
            }

            protected final K get(long i) {
                return BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)(SubList.this.from + i));
            }

            protected final void add(long i, K k) {
                SubList.this.add(i, k);
            }

            protected final void set(long i, K k) {
                SubList.this.set(i, k);
            }

            protected final void remove(long i) {
                SubList.this.remove(i);
            }

            protected final long getMaxPos() {
                return SubList.this.to - SubList.this.from;
            }

            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.pos++;
                return BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)(SubList.this.from + this.lastReturned));
            }

            public K previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.pos;
                return BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)(SubList.this.from + this.pos));
            }

            public void forEachRemaining(Consumer<? super K> action) {
                long max = SubList.this.to - SubList.this.from;
                while (this.pos < max) {
                    ++this.pos;
                    this.lastReturned = this.lastReturned;
                    action.accept(BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)(SubList.this.from + this.lastReturned)));
                }
            }
        }

        private final class SubListSpliterator
        extends ObjectBigSpliterators.LateBindingSizeIndexBasedSpliterator<K> {
            SubListSpliterator() {
                super(SubList.this.from);
            }

            private SubListSpliterator(long pos, long maxPos) {
                super(pos, maxPos);
            }

            protected final long getMaxPosFromBackingStore() {
                return SubList.this.to;
            }

            protected final K get(long i) {
                return BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)i);
            }

            protected final it.unimi.dsi.fastutil.objects.ReferenceBigArrayBigList$SubList.SubListSpliterator makeForSplit(long pos, long maxPos) {
                return new SubListSpliterator(pos, maxPos);
            }

            protected final long computeSplitPoint() {
                long defaultSplit = super.computeSplitPoint();
                return BigArrays.nearestSegmentStart((long)defaultSplit, (long)(this.pos + 1L), (long)(this.getMaxPos() - 1L));
            }

            public boolean tryAdvance(Consumer<? super K> action) {
                if (this.pos >= this.getMaxPos()) {
                    return false;
                }
                action.accept(BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)this.pos++));
                return true;
            }

            public void forEachRemaining(Consumer<? super K> action) {
                long max = this.getMaxPos();
                while (this.pos < max) {
                    action.accept(BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)this.pos++));
                }
            }
        }
    }

    private final class Spliterator
    implements ObjectSpliterator<K> {
        boolean hasSplit = false;
        long pos;
        long max;

        public Spliterator() {
            this(0L, referenceBigArrayBigList.size, false);
        }

        private Spliterator(long pos, long max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private long getWorkingMax() {
            return this.hasSplit ? this.max : ReferenceBigArrayBigList.this.size;
        }

        public int characteristics() {
            return 16464;
        }

        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        public boolean tryAdvance(Consumer<? super K> action) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action.accept(BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)this.pos++));
            return true;
        }

        public void forEachRemaining(Consumer<? super K> action) {
            long max = this.getWorkingMax();
            while (this.pos < max) {
                action.accept(BigArrays.get((Object[][])ReferenceBigArrayBigList.this.a, (long)this.pos));
                ++this.pos;
            }
        }

        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            long max = this.getWorkingMax();
            if (this.pos >= max) {
                return 0L;
            }
            long remaining = max - this.pos;
            if (n < remaining) {
                this.pos += n;
                return n;
            }
            n = remaining;
            this.pos = max;
            return n;
        }

        public ObjectSpliterator<K> trySplit() {
            long max = this.getWorkingMax();
            long retLen = max - this.pos >> 1;
            if (retLen <= 1L) {
                return null;
            }
            this.max = max;
            long myNewPos = this.pos + retLen;
            long retMax = myNewPos = BigArrays.nearestSegmentStart((long)myNewPos, (long)(this.pos + 1L), (long)(max - 1L));
            long oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

