/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.paging;

import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedFlux;
import com.azure.core.util.paging.ContinuationState;
import com.azure.core.util.paging.PageRetriever;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ContinuablePagedFluxCore<C, T, P extends ContinuablePage<C, T>>
extends ContinuablePagedFlux<C, T, P> {
    private final ClientLogger logger = new ClientLogger(ContinuablePagedFluxCore.class);
    final Supplier<PageRetriever<C, P>> pageRetrieverProvider;
    final Integer defaultPageSize;

    protected ContinuablePagedFluxCore(Supplier<PageRetriever<C, P>> pageRetrieverProvider) {
        this(pageRetrieverProvider, null, null);
    }

    protected ContinuablePagedFluxCore(Supplier<PageRetriever<C, P>> pageRetrieverProvider, int pageSize) {
        this(pageRetrieverProvider, pageSize, null);
    }

    protected ContinuablePagedFluxCore(Supplier<PageRetriever<C, P>> pageRetrieverProvider, Integer pageSize, Predicate<C> continuationPredicate) {
        super(continuationPredicate);
        this.pageRetrieverProvider = Objects.requireNonNull(pageRetrieverProvider, "'pageRetrieverProvider' function cannot be null.");
        if (pageSize != null && pageSize <= 0) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'pageSize' must be greater than 0 required but provided: " + pageSize));
        }
        this.defaultPageSize = pageSize;
    }

    public Integer getPageSize() {
        return this.defaultPageSize;
    }

    @Override
    public Flux<P> byPage() {
        return this.byPage(this.pageRetrieverProvider, null, this.defaultPageSize);
    }

    @Override
    public Flux<P> byPage(C continuationToken) {
        if (continuationToken == null) {
            return Flux.empty();
        }
        return this.byPage(this.pageRetrieverProvider, continuationToken, this.defaultPageSize);
    }

    @Override
    public Flux<P> byPage(int preferredPageSize) {
        if (preferredPageSize <= 0) {
            return Flux.error((Throwable)new IllegalArgumentException("preferredPageSize > 0 required but provided: " + preferredPageSize));
        }
        return this.byPage(this.pageRetrieverProvider, null, preferredPageSize);
    }

    @Override
    public Flux<P> byPage(C continuationToken, int preferredPageSize) {
        if (preferredPageSize <= 0) {
            return Flux.error((Throwable)new IllegalArgumentException("preferredPageSize > 0 required but provided: " + preferredPageSize));
        }
        if (continuationToken == null) {
            return Flux.empty();
        }
        return this.byPage(this.pageRetrieverProvider, continuationToken, preferredPageSize);
    }

    public void subscribe(CoreSubscriber<? super T> coreSubscriber) {
        this.byPage(this.pageRetrieverProvider, null, this.defaultPageSize).flatMap(page -> {
            IterableStream iterableStream = page.getElements();
            return iterableStream == null ? Flux.empty() : Flux.fromIterable(page.getElements());
        }).subscribe(coreSubscriber);
    }

    private Flux<P> byPage(Supplier<PageRetriever<C, P>> provider, C continuationToken, Integer pageSize) {
        return Flux.defer(() -> {
            PageRetriever pageRetriever = (PageRetriever)provider.get();
            ContinuationState<Object> state = new ContinuationState<Object>(continuationToken);
            return this.retrievePages(state, pageRetriever, pageSize);
        });
    }

    private Flux<P> retrievePages(ContinuationState<C> state, PageRetriever<C, P> pageRetriever, Integer pageSize) {
        return this.retrievePage(state, pageRetriever, pageSize).expand(page -> {
            state.setLastContinuationToken(page.getContinuationToken(), t -> !this.getContinuationPredicate().test(t));
            return Flux.defer(() -> this.retrievePage(state, pageRetriever, pageSize));
        }, 4);
    }

    private Flux<P> retrievePage(ContinuationState<C> state, PageRetriever<C, P> pageRetriever, Integer pageSize) {
        if (state.isDone()) {
            return Flux.empty();
        }
        return pageRetriever.get(state.getLastContinuationToken(), pageSize).switchIfEmpty((Publisher)Flux.defer(() -> {
            state.setLastContinuationToken(null);
            return Mono.empty();
        }));
    }
}

