/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.bitwise;

import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class BitValueCountFlagEvaluator
extends AbstractScalarEval {
    private final AMutableInt64 resultMutableInt64 = new AMutableInt64(0L);
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final IScalarEvaluator valueEvaluator;
    private final IScalarEvaluator countEvaluator;
    private IScalarEvaluator flagEvaluator;
    private final IPointable valuePointable = new VoidPointable();
    private final IPointable countPointable = new VoidPointable();
    private IPointable flagPointable;
    private final ISerializerDeserializer aInt64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private final IEvaluatorContext context;

    BitValueCountFlagEvaluator(IEvaluatorContext context, IScalarEvaluatorFactory[] argEvaluatorFactories, FunctionIdentifier functionIdentifier, SourceLocation sourceLocation) throws HyracksDataException {
        super(sourceLocation, functionIdentifier);
        this.context = context;
        this.valueEvaluator = argEvaluatorFactories[0].createScalarEvaluator(context);
        this.countEvaluator = argEvaluatorFactories[1].createScalarEvaluator(context);
        if (argEvaluatorFactories.length > 2) {
            this.flagEvaluator = argEvaluatorFactories[2].createScalarEvaluator(context);
            this.flagPointable = new VoidPointable();
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int countStartOffset;
        int valueStartOffset;
        this.valueEvaluator.evaluate(tuple, this.valuePointable);
        this.countEvaluator.evaluate(tuple, this.countPointable);
        if (this.flagEvaluator != null) {
            this.flagEvaluator.evaluate(tuple, this.flagPointable);
        }
        if (PointableHelper.checkAndSetMissingOrNull(result, this.valuePointable, this.countPointable, this.flagPointable)) {
            return;
        }
        byte[] valueBytes = this.valuePointable.getByteArray();
        if (!PointableHelper.isValidLongValue(valueBytes, valueStartOffset = this.valuePointable.getStartOffset(), true)) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)valueBytes[valueStartOffset], (int)0, (ATypeTag)ATypeTag.BIGINT);
            PointableHelper.setNull(result);
            return;
        }
        byte[] countBytes = this.countPointable.getByteArray();
        if (!PointableHelper.isValidLongValue(countBytes, countStartOffset = this.countPointable.getStartOffset(), true)) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)countBytes[countStartOffset], (int)1, (ATypeTag)ATypeTag.BIGINT);
            PointableHelper.setNull(result);
            return;
        }
        boolean isRotate = false;
        if (this.flagEvaluator != null) {
            int flagStartOffset;
            byte[] flagBytes = this.flagPointable.getByteArray();
            ATypeTag flagTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(flagBytes[flagStartOffset = this.flagPointable.getStartOffset()]);
            if (flagTypeTag != ATypeTag.BOOLEAN) {
                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.context, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)flagBytes[flagStartOffset], (int)2, (ATypeTag)ATypeTag.BOOLEAN);
                PointableHelper.setNull(result);
                return;
            }
            isRotate = ABooleanSerializerDeserializer.getBoolean((byte[])flagBytes, (int)(flagStartOffset + 1));
        }
        long longValue = ATypeHierarchy.getLongValue((String)this.funID.getName(), (int)0, (byte[])valueBytes, (int)valueStartOffset);
        long count = ATypeHierarchy.getLongValue((String)this.funID.getName(), (int)1, (byte[])countBytes, (int)countStartOffset);
        if (count > 0L) {
            longValue = isRotate ? Long.rotateLeft(longValue, (int)(count % 64L)) : (longValue <<= (int)count);
        }
        if (count < 0L) {
            longValue = isRotate ? Long.rotateRight(longValue, (int)Math.abs(count % -64L)) : (longValue >>= (int)Math.abs(count));
        }
        this.resultStorage.reset();
        this.resultMutableInt64.setValue(longValue);
        this.aInt64Serde.serialize((Object)this.resultMutableInt64, this.resultStorage.getDataOutput());
        result.set((IValueReference)this.resultStorage);
    }
}

