/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.IResultStateRecord;
import org.apache.hyracks.api.result.ResultDirectoryRecord;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.api.result.ResultSetMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultJobRecord
implements IResultStateRecord {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final long timestamp = System.nanoTime();
    private long jobStartTime;
    private long jobEndTime;
    private Status status = new Status();
    private ResultSetId rsId;
    private ResultSetMetaData resultSetMetaData;

    private void updateState(State newStatus) {
        if (this.status.state != State.FAILED) {
            this.status.setState(newStatus);
        }
    }

    public void start() {
        this.jobStartTime = System.nanoTime();
        this.updateState(State.RUNNING);
    }

    public void finish() {
        this.jobEndTime = System.nanoTime();
    }

    public long getJobDuration() {
        return this.jobEndTime - this.jobStartTime;
    }

    public void success() {
        this.updateState(State.SUCCESS);
    }

    public void fail(List<Exception> exceptions) {
        this.updateState(State.FAILED);
        this.status.setExceptions(exceptions);
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"status\": ").append(this.status.toString()).append(", ");
        sb.append("\"timestamp\": ").append(this.timestamp).append(", ");
        sb.append("\"resultset\": ").append(this.resultSetMetaData).append(" }");
        return sb.toString();
    }

    public synchronized void setResultSetMetaData(ResultSetId rsId, IResultMetadata metadata, int nPartitions) throws HyracksDataException {
        if (this.rsId == null) {
            this.rsId = rsId;
            this.resultSetMetaData = new ResultSetMetaData(nPartitions, metadata);
        } else if (!this.rsId.equals(rsId) || this.resultSetMetaData.getRecords().length != nPartitions) {
            this.logInconsistentMetadata(rsId, nPartitions);
            throw HyracksDataException.create(ErrorCode.INCONSISTENT_RESULT_METADATA, new Serializable[]{this.rsId.toString()});
        }
    }

    public synchronized ResultDirectoryRecord getOrCreateDirectoryRecord(int partition) {
        ResultDirectoryRecord[] records = this.resultSetMetaData.getRecords();
        if (records[partition] == null) {
            records[partition] = new ResultDirectoryRecord();
        }
        return records[partition];
    }

    public synchronized ResultDirectoryRecord getDirectoryRecord(int partition) throws HyracksDataException {
        ResultDirectoryRecord[] records = this.resultSetMetaData.getRecords();
        if (records[partition] == null) {
            throw HyracksDataException.create(ErrorCode.RESULT_NO_RECORD, Integer.valueOf(partition), this.rsId);
        }
        return records[partition];
    }

    public synchronized void updateState() {
        ResultDirectoryRecord[] records;
        int successCount = 0;
        for (ResultDirectoryRecord record : records = this.resultSetMetaData.getRecords()) {
            if (record == null || record.getStatus() != ResultDirectoryRecord.Status.SUCCESS) continue;
            ++successCount;
        }
        if (successCount == records.length) {
            this.success();
        }
    }

    public synchronized ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    private void logInconsistentMetadata(ResultSetId rsId, int nPartitions) {
        if (LOGGER.isWarnEnabled()) {
            int expectedPartitions;
            LOGGER.warn("inconsistent result metadata for result set {}", (Object)this.rsId);
            if (!this.rsId.equals(rsId)) {
                LOGGER.warn("inconsistent result set id. Current {}, new {}", (Object)this.rsId, (Object)rsId);
            }
            if ((expectedPartitions = this.resultSetMetaData.getRecords().length) != nPartitions) {
                LOGGER.warn("inconsistent result set number of partitions. Current {}, new {}", (Object)expectedPartitions, (Object)nPartitions);
            }
        }
    }

    public static class Status
    implements Serializable {
        private static final long serialVersionUID = 1L;
        State state = State.IDLE;
        private List<Exception> exceptions;

        public State getState() {
            return this.state;
        }

        void setState(State state) {
            this.state = state;
        }

        public List<Exception> getExceptions() {
            return this.exceptions;
        }

        void setExceptions(List<Exception> exceptions) {
            this.exceptions = exceptions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ \"state\": \"").append(this.state.name()).append("\"");
            if (this.exceptions != null && !this.exceptions.isEmpty()) {
                sb.append(", \"exceptions\": ");
                ArrayList msgs = new ArrayList();
                this.exceptions.forEach(e -> msgs.add("\"" + e.getMessage() + "\""));
                sb.append(Arrays.toString(msgs.toArray()));
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public static enum State {
        IDLE,
        RUNNING,
        SUCCESS,
        FAILED;

    }
}

