/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.io;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;

public class IODeviceHandle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File mount;
    private final String workspace;

    public IODeviceHandle(File mount, String workspace) {
        this.mount = mount;
        this.workspace = workspace == null ? null : (workspace.endsWith(File.separator) ? workspace.substring(0, workspace.length() - 1) : workspace);
    }

    public File getMount() {
        return this.mount;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public FileReference createFileRef(String relPath) {
        return new FileReference(this, relPath);
    }

    public static List<IODeviceHandle> getDevices(String[] ioDevices) {
        ArrayList<IODeviceHandle> devices = new ArrayList<IODeviceHandle>();
        for (String ioDevice : ioDevices) {
            String devPath = Paths.get(ioDevice.trim(), new String[0]).toAbsolutePath().normalize().toString();
            devices.add(new IODeviceHandle(new File(devPath), "."));
        }
        return devices;
    }

    public String getRelativePath(String absolutePath) throws HyracksDataException {
        if (absolutePath.indexOf(this.mount.getAbsolutePath()) != 0) {
            throw new HyracksDataException("Passed path: " + absolutePath + " is not inside the device " + this.mount.getAbsolutePath());
        }
        return absolutePath.substring(this.mount.getAbsolutePath().length());
    }

    public boolean contains(String relPath) {
        return new File(this.mount, relPath).exists();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IODeviceHandle) {
            return this.mount.getAbsolutePath().equals(((IODeviceHandle)o).getMount().getAbsolutePath());
        }
        return false;
    }

    public int hashCode() {
        return this.mount.getAbsolutePath().hashCode();
    }

    public String toString() {
        return "mount: " + this.mount.getAbsolutePath() + (String)(this.workspace == null ? "" : ", workspace: " + this.workspace);
    }
}

