/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.runningaggregates.std;

import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IWindowAggregateEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class NtileRunningAggregateEvaluator
implements IWindowAggregateEvaluator {
    private final IScalarEvaluator evalNumGroups;
    private final VoidPointable argNumGroups = VoidPointable.FACTORY.createPointable();
    private final FunctionIdentifier funId;
    private final ISerializerDeserializer<AInt64> serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final AMutableInt64 aInt64 = new AMutableInt64(0L);
    private long partitionLength;
    private long groupSize;
    private long groupRemainder;
    private long resultValue;
    private long count;
    private boolean isNull;

    NtileRunningAggregateEvaluator(IScalarEvaluator evalNumGroups, FunctionIdentifier funId) {
        this.evalNumGroups = evalNumGroups;
        this.funId = funId;
    }

    public void init() throws HyracksDataException {
    }

    public void initPartition(long partitionLength) {
        this.partitionLength = partitionLength;
        this.resultValue = 0L;
        this.isNull = false;
        this.groupSize = 1L;
        this.groupRemainder = 0L;
    }

    public void step(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        if (this.resultValue == 0L) {
            this.evaluateGroupSize(tuple);
            this.count = 1L;
            this.resultValue = 1L;
        } else if (this.count < this.groupSize) {
            ++this.count;
        } else if (this.count == this.groupSize && this.groupRemainder > 0L) {
            --this.groupRemainder;
            ++this.count;
        } else {
            ++this.resultValue;
            this.count = 1L;
        }
        if (this.isNull) {
            PointableHelper.setNull(result);
        } else {
            this.resultStorage.reset();
            this.aInt64.setValue(this.resultValue);
            this.serde.serialize((Object)this.aInt64, this.resultStorage.getDataOutput());
            result.set((IValueReference)this.resultStorage);
        }
    }

    private void evaluateGroupSize(IFrameTupleReference tuple) throws HyracksDataException {
        this.evalNumGroups.evaluate(tuple, (IPointable)this.argNumGroups);
        byte[] bytes = this.argNumGroups.getByteArray();
        int offset = this.argNumGroups.getStartOffset();
        if (bytes[offset] == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
            this.isNull = true;
        } else {
            long numGroups = ATypeHierarchy.getLongValue((String)this.funId.getName(), (int)0, (byte[])bytes, (int)offset);
            if (numGroups > 0L && numGroups <= this.partitionLength) {
                this.groupSize = this.partitionLength / numGroups;
                this.groupRemainder = this.partitionLength % numGroups;
            }
        }
    }
}

