/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADayTimeDuration;
import org.apache.asterix.om.base.AMutableDayTimeDuration;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class DurationFromIntervalDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final FunctionIdentifier FID = BuiltinFunctions.DURATION_FROM_INTERVAL;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new DurationFromIntervalDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable argPtr = new VoidPointable();
                    private IScalarEvaluator eval;
                    private ISerializerDeserializer<ADayTimeDuration> dayTimeDurationSerde;
                    private AMutableDayTimeDuration aDayTimeDuration;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.dayTimeDurationSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADAYTIMEDURATION);
                        this.aDayTimeDuration = new AMutableDayTimeDuration(0L);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        int offset;
                        this.resultStorage.reset();
                        this.eval.evaluate(tuple, this.argPtr);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr)) {
                            return;
                        }
                        byte[] bytes = this.argPtr.getByteArray();
                        if (bytes[offset = this.argPtr.getStartOffset()] != ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG) {
                            throw new TypeMismatchException(DurationFromIntervalDescriptor.this.sourceLoc, DurationFromIntervalDescriptor.this.getIdentifier(), (Integer)0, bytes[offset], ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                        }
                        long chrononStart = AIntervalSerializerDeserializer.getIntervalStart((byte[])bytes, (int)(offset + 1));
                        long chrononEnd = AIntervalSerializerDeserializer.getIntervalEnd((byte[])bytes, (int)(offset + 1));
                        byte intervalTypeTag = AIntervalSerializerDeserializer.getIntervalTimeType((byte[])bytes, (int)(offset + 1));
                        if (intervalTypeTag == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                            chrononStart *= 86400000L;
                            chrononEnd *= 86400000L;
                        }
                        this.aDayTimeDuration.setMilliseconds(chrononEnd - chrononStart);
                        this.dayTimeDurationSerde.serialize((Object)this.aDayTimeDuration, this.out);
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return FID;
    }
}

