/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.text.SimpleDateFormat;

public class ExecutionTimeStopWatch {
    private long startTime = 0L;
    private long stopTime = 0L;
    private long elapsedTime = 0L;
    private long elapsedTimeBetweenTimeStamp = 0L;
    private long startTimeStamp = 0L;
    private long endTimeStamp = 0L;
    private boolean isStarted = false;
    private String message;

    public void start() {
        this.elapsedTime = 0L;
        this.startTimeStamp = this.startTime = System.currentTimeMillis();
        this.isStarted = true;
        this.message = "";
    }

    public void suspend() {
        this.stopTime = System.currentTimeMillis();
        this.elapsedTime += this.stopTime - this.startTime;
    }

    public void resume() {
        this.startTime = System.currentTimeMillis();
    }

    public void finish() {
        this.endTimeStamp = this.stopTime;
        this.elapsedTimeBetweenTimeStamp = this.endTimeStamp - this.startTimeStamp;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public double getElapsedTimeSecs() {
        return (double)this.elapsedTime / 1000.0;
    }

    public long getElapsedTimeStamp() {
        return this.elapsedTimeBetweenTimeStamp;
    }

    public double getElapsedTimeStampSecs() {
        return (double)this.elapsedTimeBetweenTimeStamp / 1000.0;
    }

    public String getMessage(String operatorName, long timeStamp) {
        this.message = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(timeStamp) + "\t" + operatorName + "\t" + this.getElapsedTime() + "\t" + this.getElapsedTimeSecs() + "\t" + this.getElapsedTimeStamp() + "\t" + this.getElapsedTimeStampSecs() + "\n";
        return this.message;
    }

    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    public long getEndTimeStamp() {
        return this.endTimeStamp;
    }
}

