/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.util;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.data.std.api.IDataOutputProvider;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.data.std.util.RewindableDataOutputStream;

public class GrowableArray
implements IDataOutputProvider {
    private final ByteArrayAccessibleOutputStream baaos;
    private final RewindableDataOutputStream dos;

    public GrowableArray() {
        this.baaos = new ByteArrayAccessibleOutputStream();
        this.dos = new RewindableDataOutputStream(this.baaos);
    }

    public GrowableArray(int size) {
        this.baaos = new ByteArrayAccessibleOutputStream(size);
        this.dos = new RewindableDataOutputStream(this.baaos);
    }

    @Override
    public DataOutput getDataOutput() {
        return this.dos;
    }

    public void reset() {
        this.baaos.reset();
    }

    public void rewindPositionBy(int delta) {
        this.baaos.rewindPositionBy(delta);
        this.dos.rewindWrittenBy(delta);
    }

    public byte[] getByteArray() {
        return this.baaos.getByteArray();
    }

    public int getLength() {
        return this.baaos.size();
    }

    public void append(IValueReference value) throws IOException {
        this.append(value.getByteArray(), value.getStartOffset(), value.getLength());
    }

    public void append(byte[] data, int offset, int length) throws IOException {
        this.dos.write(data, offset, length);
    }

    public void setSize(int bytesRequired) {
        this.baaos.setSize(bytesRequired);
    }

    public int hashCode() {
        return 31 * this.baaos.getLength();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GrowableArray)) {
            return false;
        }
        GrowableArray other = (GrowableArray)obj;
        int length = this.baaos.getLength();
        if (other.baaos.getLength() != length) {
            return false;
        }
        byte[] array1 = this.baaos.getByteArray();
        byte[] array2 = other.baaos.getByteArray();
        for (int i = 0; i < length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }
}

