/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public abstract class AbstractExtractExprRule
implements IAlgebraicRewriteRule {
    protected static LogicalVariable extractExprIntoAssignOpRef(ILogicalExpression gExpr, Mutable<ILogicalOperator> opRef2, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable v = context.newVar();
        AssignOperator a = new AssignOperator(v, (Mutable)new MutableObject((Object)gExpr));
        a.setSourceLocation(gExpr.getSourceLocation());
        a.getInputs().add(new MutableObject(opRef2.getValue()));
        opRef2.setValue((Object)a);
        if (gExpr.getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            context.addNotToBeInlinedVar(v);
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)a);
        return v;
    }

    protected static <T> boolean extractComplexExpressions(ILogicalOperator op, List<T> exprList, Function<T, Mutable<ILogicalExpression>> exprGetter, Predicate<ILogicalExpression> retainPredicate, IOptimizationContext context) throws AlgebricksException {
        if (!AbstractExtractExprRule.hasComplexExpressions(exprList, exprGetter)) {
            return false;
        }
        boolean rewritten = false;
        Mutable inputOpRef = (Mutable)op.getInputs().get(0);
        for (T item : exprList) {
            Mutable<ILogicalExpression> exprMutable = exprGetter.apply(item);
            ILogicalExpression expr = (ILogicalExpression)exprMutable.getValue();
            if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE || retainPredicate.test(expr)) continue;
            LogicalVariable v = AbstractExtractExprRule.extractExprIntoAssignOpRef(expr, (Mutable<ILogicalOperator>)inputOpRef, context);
            VariableReferenceExpression vRef = new VariableReferenceExpression(v);
            vRef.setSourceLocation(expr.getSourceLocation());
            exprMutable.setValue((Object)vRef);
            rewritten = true;
        }
        context.computeAndSetTypeEnvironmentForOperator(op);
        return rewritten;
    }

    private static <T> boolean hasComplexExpressions(List<T> exprList, Function<T, Mutable<ILogicalExpression>> exprGetter) {
        for (T item : exprList) {
            Mutable<ILogicalExpression> exprMutable = exprGetter.apply(item);
            if (((ILogicalExpression)exprMutable.getValue()).getExpressionTag() == LogicalExpressionTag.VARIABLE) continue;
            return true;
        }
        return false;
    }
}

