/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.apache.camel.CamelContext;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.task.AbstractTask;
import org.apache.camel.support.task.AbstractTaskBuilder;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.Task;
import org.apache.camel.support.task.TaskManagerRegistry;
import org.apache.camel.support.task.TaskRunFailureException;
import org.apache.camel.support.task.budget.TimeBudget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundTask
extends AbstractTask
implements BlockingTask {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundTask.class);
    private final TimeBudget budget;
    private final ScheduledExecutorService service;
    private final CountDownLatch latch = new CountDownLatch(1);
    private Duration elapsed = Duration.ZERO;
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicBoolean completed = new AtomicBoolean();

    BackgroundTask(TimeBudget budget, ScheduledExecutorService service, String name) {
        super(name);
        this.budget = budget;
        this.service = Objects.requireNonNull(service);
    }

    private void runTaskWrapper(CamelContext camelContext, BooleanSupplier supplier) {
        LOG.trace("Current latch value: {}", (Object)this.latch.getCount());
        if (this.latch.getCount() == 0L) {
            return;
        }
        TaskManagerRegistry registry = null;
        if (camelContext != null) {
            registry = PluginHelper.getTaskManagerRegistry(camelContext.getCamelContextExtension());
            registry.addTask(this);
        }
        if (!this.budget.next()) {
            LOG.warn("The task {} does not have more budget to continue running", (Object)this.getName());
            this.status = Task.Status.Exhausted;
            this.completed.set(false);
            if (registry != null) {
                registry.removeTask(this);
            }
            this.latch.countDown();
            return;
        }
        this.lastAttemptTime = System.currentTimeMillis();
        if (this.firstAttemptTime < 0L) {
            this.firstAttemptTime = this.lastAttemptTime;
        }
        try {
            if (this.doRun(supplier)) {
                this.status = Task.Status.Completed;
                this.completed.set(true);
                if (registry != null) {
                    registry.removeTask(this);
                }
                this.latch.countDown();
                LOG.trace("Task {} succeeded and the current task is unscheduled: {}", (Object)this.getName(), (Object)this.latch.getCount());
            }
        }
        catch (Exception e) {
            this.status = Task.Status.Failed;
            this.cause = e;
            throw e;
        }
        this.nextAttemptTime = this.lastAttemptTime + this.budget.interval();
    }

    public Future<?> schedule(CamelContext camelContext, BooleanSupplier supplier) {
        this.running.set(true);
        return this.service.scheduleWithFixedDelay(() -> this.runTaskWrapper(camelContext, supplier), this.budget.initialDelay(), this.budget.interval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean run(CamelContext camelContext, BooleanSupplier supplier) {
        this.running.set(true);
        ScheduledFuture<?> task = this.service.scheduleWithFixedDelay(() -> this.runTaskWrapper(camelContext, supplier), this.budget.initialDelay(), this.budget.interval(), TimeUnit.MILLISECONDS);
        this.waitForTaskCompletion(camelContext, task);
        return this.completed.get();
    }

    protected boolean doRun(BooleanSupplier supplier) {
        try {
            this.cause = null;
            return supplier.getAsBoolean();
        }
        catch (TaskRunFailureException e) {
            LOG.debug("Task {} failed at {} iterations and will attempt again on next interval: {}", new Object[]{this.getName(), this.budget.iteration(), e.getMessage()});
            this.cause = e;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTaskCompletion(CamelContext camelContext, Future<?> task) {
        try {
            if (this.budget.maxDuration() == -1L) {
                this.latch.await();
            } else if (!this.latch.await(this.budget.maxDuration(), TimeUnit.MILLISECONDS)) {
                LOG.debug("Timeout out waiting for the completion of the task");
            } else {
                LOG.debug("The task has finished the execution and it is ready to continue");
            }
            TaskManagerRegistry registry = null;
            if (camelContext != null) {
                registry = PluginHelper.getTaskManagerRegistry(camelContext.getCamelContextExtension());
            }
            if (registry != null) {
                registry.removeTask(this);
            }
            task.cancel(true);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for the repeatable task to execute: {}", (Object)e.getMessage(), (Object)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.elapsed = this.budget.elapsed();
            this.running.set(false);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public Duration elapsed() {
        return this.elapsed;
    }

    @Override
    public int iteration() {
        return this.budget.iteration();
    }

    @Override
    public long getCurrentDelay() {
        return this.budget.interval();
    }

    public static class BackgroundTaskBuilder
    extends AbstractTaskBuilder<BackgroundTask> {
        private TimeBudget budget;
        private ScheduledExecutorService service;

        public BackgroundTaskBuilder withBudget(TimeBudget timeBudget) {
            this.budget = timeBudget;
            return this;
        }

        public BackgroundTaskBuilder withScheduledExecutor(ScheduledExecutorService service) {
            this.service = service;
            return this;
        }

        @Override
        public BackgroundTask build() {
            return new BackgroundTask(this.budget, this.service, this.getName());
        }
    }
}

